/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.profile.idas;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.common.AuthNAnonymousMaterials;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.sts.api.IClaim;
import org.eclipse.higgins.sts.api.IClaimType;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IProfile;
import org.eclipse.higgins.sts.api.IProfileService;
import org.eclipse.higgins.sts.common.Claim;
import org.eclipse.higgins.sts.common.ClaimType;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.NodeList;

public class ProfileService
implements IProfileService {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$server$profile$idas$ProfileService == null ? (class$org$eclipse$higgins$sts$server$profile$idas$ProfileService = ProfileService.class$("org.eclipse.higgins.sts.server.profile.idas.ProfileService")) : class$org$eclipse$higgins$sts$server$profile$idas$ProfileService).getName());
    private boolean bInitialized = false;
    private Map mapGlobalSettings = null;
    protected String strComponentName = null;
    private Map mapComponentSettings = null;
    private List listSupportedClaims = null;
    private Map mapAttributeClaims = null;
    private Map mapShortNameAttribute = null;
    private Map mapShortNameClaimUri = null;
    private String strCardImage = null;
    private X509Certificate certSSL = null;
    private IXMLSecurityExtension xmlSecurityExtension = null;
    private IdASRegistry idasRegistry = null;
    private String contextId = null;
    private URI digitalSubjectType = null;
    private boolean allowAnonymousAccess = false;
    private URI CARD_KEY_HASH_URI = URI.create("http://www.eclipse.org/higgins/ontologies/2008/6/higgins#cardKeyHash");
    private String storeUserName = null;
    private String storePassword = null;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$server$profile$idas$ProfileService;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public ProfileService() {
        this.log.trace((Object)"ProfileService::ProfileService");
    }

    public String createProfile(IConstants constants, String strUserIdentifier, String strUserPassword) throws Exception {
        this.log.trace((Object)"ProfileService::createProfile");
        IContext context = this.idasRegistry.createContext(this.contextId);
        if (this.storeUserName != null && this.storePassword != null) {
            try {
                context.open((IAuthNMaterials)new AuthNNamePasswordMaterials(context, this.storeUserName, this.storePassword));
            }
            catch (Exception e) {
                throw new Exception("ERROR Invalid Username / Password");
            }
        } else if (this.allowAnonymousAccess) {
            try {
                context.open((IAuthNMaterials)new AuthNAnonymousMaterials());
            }
            catch (Exception e) {
                throw new Exception("ERROR Could not open context as anonymous");
            }
        } else {
            throw new Exception("Insufficient privileages to open context");
        }
        IEntity subj = context.addEntity(this.digitalSubjectType, strUserIdentifier);
        IAttribute attr = subj.addAttribute(AuthNNamePasswordMaterials.ATTR_MANAGED_URI);
        attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)strUserPassword);
        context.applyUpdates();
        context.close();
        return "SUCCESS";
    }

    public String decryptToken(IConstants constants, String strToken) throws Exception {
        this.log.trace((Object)"ProfileService::decryptToken");
        if (null != strToken) {
            Element elemToken = new Element();
            elemToken.set((Object)strToken);
            this.log.trace((Object)"Decrypting Security Token");
            IElement elemDecryptedToken = this.xmlSecurityExtension.DecryptElement((IElement)elemToken, (PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
            String strResult = (String)elemDecryptedToken.getAs(class$java$lang$String == null ? (class$java$lang$String = ProfileService.class$("java.lang.String")) : class$java$lang$String);
            this.log.trace((Object)("Decrypted Security Token: " + strResult));
            return strResult;
        }
        return "Success";
    }

    public String deleteProfile(IConstants constants, String strUserIdentifier, String strUserPassword) throws Exception {
        this.log.trace((Object)"ProfileService::deleteProfile");
        IContext context = null;
        if (null != strUserIdentifier && null != strUserPassword) {
            try {
                context = this.idasRegistry.createContext(this.contextId);
                context.open((IAuthNMaterials)new AuthNNamePasswordMaterials(context, strUserIdentifier, strUserPassword));
            }
            catch (Exception e) {
                throw new Exception("ERROR Invalid Username / Password");
            }
        }
        if (context == null) {
            return "ERROR Invalid Username / Password";
        }
        IEntity subj = context.getEntity(strUserIdentifier);
        subj.remove();
        context.applyUpdates();
        context.close();
        return "SUCCESS";
    }

    public String getManagedCard(IConstants constants, String strCardName, String strUsername, String strPassword, String strCredentialType, String strRequireAppliesTo, String strToken) throws Exception {
        boolean bRequireAppliesTo;
        this.log.trace((Object)"ProfileService::getManagedCard");
        this.log.trace((Object)("CredentialType: " + strCredentialType));
        String strPPID = null;
        String strModulus = null;
        String strExponent = null;
        String strThumbprint = null;
        boolean bl = bRequireAppliesTo = null != strRequireAppliesTo && strRequireAppliesTo.matches("true");
        if (null != strToken) {
            Element elemToken = new Element();
            elemToken.set((Object)strToken);
            this.log.trace((Object)"Decrypting Security Token");
            IElement elemDecryptedToken = this.xmlSecurityExtension.DecryptElement((IElement)elemToken, (PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
            this.log.trace((Object)("Decrypted Security Token: " + (String)elemDecryptedToken.getAs(class$java$lang$String == null ? (class$java$lang$String = ProfileService.class$("java.lang.String")) : class$java$lang$String)));
            this.log.trace((Object)"Looking for the PPID");
            org.w3c.dom.Element domDecryptedToken = (org.w3c.dom.Element)elemDecryptedToken.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = ProfileService.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            NodeList nlAttributes = domDecryptedToken.getElementsByTagNameNS(constants.getSAML10AssertionNamespace().toString(), "Attribute");
            if (null == nlAttributes) {
                this.log.trace((Object)"No Attribute found (getElementsByTagName returned null)");
            } else if (0 == nlAttributes.getLength()) {
                this.log.trace((Object)"No Attribute found (0 == getLength())");
            } else {
                for (int i = 0; i < nlAttributes.getLength(); ++i) {
                    this.log.trace((Object)"Processing Attribute element");
                    org.w3c.dom.Element elemAttribute = (org.w3c.dom.Element)nlAttributes.item(i);
                    String strAttributeName = elemAttribute.getAttribute("AttributeName");
                    this.log.trace((Object)("Attribute: " + strAttributeName));
                    if (!strAttributeName.matches("privatepersonalidentifier")) continue;
                    NodeList nlAttributeValues = elemAttribute.getElementsByTagNameNS(constants.getSAML10AssertionNamespace().toString(), "AttributeValue");
                    if (null == nlAttributeValues) {
                        this.log.trace((Object)"No AttributeValue found (getElementsByTagName returned null)");
                        continue;
                    }
                    if (0 == nlAttributeValues.getLength()) {
                        this.log.trace((Object)"No AttributeValue found (0 == getLength())");
                        continue;
                    }
                    if (1 != nlAttributeValues.getLength()) {
                        this.log.trace((Object)"More than 1 AttributeValue found");
                        continue;
                    }
                    org.w3c.dom.Element elemAttributeValue = (org.w3c.dom.Element)nlAttributeValues.item(0);
                    strPPID = XMLHelper.getTextContent((org.w3c.dom.Element)elemAttributeValue);
                    this.log.trace((Object)("PPID: " + strPPID));
                    break;
                }
            }
            NodeList nlModuluses = domDecryptedToken.getElementsByTagNameNS(constants.getXMLSignatureNamespace().toString(), "Modulus");
            if (null == nlModuluses) {
                this.log.trace((Object)"No Modulus found (getElementsByTagName returned null)");
            } else if (0 == nlModuluses.getLength()) {
                this.log.trace((Object)"No Modulus found (0 == getLength())");
            } else {
                this.log.trace((Object)"Processing Modulus element");
                org.w3c.dom.Element elemModulus = (org.w3c.dom.Element)nlModuluses.item(0);
                strModulus = XMLHelper.getTextContent((org.w3c.dom.Element)elemModulus);
                this.log.trace((Object)("Modulus: " + strModulus));
            }
            NodeList nlExponents = domDecryptedToken.getElementsByTagNameNS(constants.getXMLSignatureNamespace().toString(), "Exponent");
            if (null == nlExponents) {
                this.log.trace((Object)"No Exponent found (getElementsByTagName returned null)");
            } else if (0 == nlExponents.getLength()) {
                this.log.trace((Object)"No Exponent found (0 == getLength())");
            } else {
                this.log.trace((Object)"Processing Exponent element");
                org.w3c.dom.Element elemExponent = (org.w3c.dom.Element)nlExponents.item(0);
                strExponent = XMLHelper.getTextContent((org.w3c.dom.Element)elemExponent);
                this.log.trace((Object)("Exponent: " + strExponent));
            }
            String strResult = this.modifyProfileSetCardKeyHash(constants, strUsername, strPassword, strPPID, strModulus, strExponent);
            if (!strResult.matches("Success")) {
                return strResult;
            }
        }
        this.log.trace((Object)"ProfileService::getManagedCard-0");
        String strSSLCertificate = new String(Base64.encodeBase64((byte[])this.certSSL.getEncoded()));
        this.log.trace((Object)"ProfileService::getManagedCard-1");
        String strEscapedCardName = strCardName.replaceAll(" ", "-");
        this.log.trace((Object)"ProfileService::getManagedCard-2");
        String strId = "IC01";
        this.log.trace((Object)"ProfileService::getManagedCard-3");
        String strInformationCard = "<InformationCard xmlns=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xml:lang=\"en-us\"><InformationCardReference><CardId>" + ((URI)this.mapComponentSettings.get("CardId")).toString() + "&amp;cardid=" + strEscapedCardName + "</CardId>" + "<CardVersion>1</CardVersion>" + "</InformationCardReference>" + "<CardName>" + strCardName + "</CardName>" + "<CardImage MimeType=\"image/jpeg\">" + this.strCardImage + "</CardImage>" + "<Issuer>" + ((URI)this.mapGlobalSettings.get("TokenServiceIssuerURI")).toString() + "</Issuer>" + "<TimeIssued>2006-10-28T00:00:00.999Z</TimeIssued>" + "<TimeExpires>9999-12-31T23:59:59.9999999Z</TimeExpires>" + "<TokenServiceList>" + "<TokenService>" + "<EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">" + "<Address>" + ((URI)this.mapGlobalSettings.get("TokenServiceTrustURI")).toString() + "</Address>" + "<Metadata>" + "<Metadata xmlns=\"http://schemas.xmlsoap.org/ws/2004/09/mex\">" + "<MetadataSection>" + "<MetadataReference>" + "<Address xmlns=\"http://www.w3.org/2005/08/addressing\">";
        this.log.trace((Object)"ProfileService::getManagedCard-4");
        if (strCredentialType.matches("UsernamePassword")) {
            this.log.trace((Object)("MetadataURI: " + ((URI)this.mapGlobalSettings.get("UsernameTokenMetadataURI")).toString()));
            strInformationCard = strInformationCard + ((URI)this.mapGlobalSettings.get("UsernameTokenMetadataURI")).toString();
        } else if (strCredentialType.matches("SelfSignedSAML")) {
            this.log.trace((Object)("MetadataURI: " + ((URI)this.mapGlobalSettings.get("SelfSignedSAMLTokenMetadataURI")).toString()));
            strInformationCard = strInformationCard + ((URI)this.mapGlobalSettings.get("SelfSignedSAMLTokenMetadataURI")).toString();
        } else if (strCredentialType.startsWith("X509")) {
            strThumbprint = strCredentialType.substring("X509".length());
            this.log.trace((Object)("MetadataURI: " + ((URI)this.mapGlobalSettings.get("X509TokenMetadataURI")).toString()));
            strInformationCard = strInformationCard + ((URI)this.mapGlobalSettings.get("X509TokenMetadataURI")).toString();
        } else {
            this.log.trace((Object)"MetadataURI NOT Added");
        }
        this.log.trace((Object)"ProfileService::getManagedCard-5");
        strInformationCard = strInformationCard + "</Address></MetadataReference></MetadataSection></Metadata></Metadata><Identity xmlns=\"http://schemas.xmlsoap.org/ws/2006/02/addressingidentity\"><KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\"><X509Data><X509Certificate>" + strSSLCertificate + "</X509Certificate>" + "</X509Data>" + "</KeyInfo>" + "</Identity>" + "</EndpointReference>" + "<UserCredential>";
        this.log.trace((Object)"ProfileService::getManagedCard-6");
        if (strCredentialType.matches("UsernamePassword")) {
            strInformationCard = strInformationCard + "<DisplayCredentialHint>Enter your username and password</DisplayCredentialHint><UsernamePasswordCredential><Username>" + strUsername + "</Username>" + "</UsernamePasswordCredential>";
        } else if (strCredentialType.matches("SelfSignedSAML")) {
            strInformationCard = strInformationCard + "<SelfIssuedCredential><PrivatePersonalIdentifier>" + strPPID + "</PrivatePersonalIdentifier>" + "</SelfIssuedCredential>";
        } else if (strCredentialType.startsWith("X509")) {
            String strResult = this.modifyProfileSetX509SHA(constants, strUsername, strPassword, strThumbprint);
            if (!strResult.matches("Success")) {
                return strResult;
            }
            strInformationCard = strInformationCard + "<X509V3Credential><ds:X509Data xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><KeyIdentifier xmlns=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" ValueType=\"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1\" EncodingType=\"http://docs.oasis-open.org/wss/2004/01/oasis200401-wss-soap-message-security-1.0#Base64Binary\">" + strThumbprint + "</KeyIdentifier>" + "</ds:X509Data>" + "</X509V3Credential>";
        }
        this.log.trace((Object)"ProfileService::getManagedCard-7");
        strInformationCard = strInformationCard + "</UserCredential></TokenService></TokenServiceList><SupportedTokenTypeList><TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1</TokenType><TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0</TokenType><TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">urn:oasis:names:tc:SAML:1.0:assertion</TokenType><TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">urn:oasis:names:tc:SAML:2.0:assertion</TokenType></SupportedTokenTypeList><SupportedClaimTypeList>";
        for (int i = 0; i < this.listSupportedClaims.size(); ++i) {
            URI uriAttribute = (URI)this.listSupportedClaims.get(i);
            this.log.trace((Object)("Attribute: " + uriAttribute.toString()));
            Map mapAttributeClaim = (Map)this.mapAttributeClaims.get(uriAttribute.toString());
            if (null == mapAttributeClaim) continue;
            String strDisplayName = (String)mapAttributeClaim.get("DisplayName");
            this.log.trace((Object)("DisplayName: " + strDisplayName));
            strInformationCard = strInformationCard + "<SupportedClaimType Uri=\"" + uriAttribute.toString() + "\">" + "<DisplayTag>" + strDisplayName + "</DisplayTag>" + "<Description>" + strDisplayName + "</Description>" + "</SupportedClaimType>";
        }
        strInformationCard = strInformationCard + "</SupportedClaimTypeList>" + (bRequireAppliesTo ? "<RequireAppliesTo/>" : "") + "</InformationCard>";
        this.log.trace((Object)"ProfileService::getManagedCard-8");
        Element elemInformationCard = new Element();
        this.log.trace((Object)"ProfileService::getManagedCard-9");
        elemInformationCard.set((Object)strInformationCard);
        this.log.trace((Object)"ProfileService::getManagedCard-10");
        IElement elemSignedInformationCard = this.xmlSecurityExtension.SignEnveloping((IElement)elemInformationCard, "IC01", (X509Certificate)this.mapGlobalSettings.get("IssuerCertificate"), (PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
        this.log.trace((Object)"ProfileService::getManagedCard-11");
        String strSignedInformationCard = (String)elemSignedInformationCard.getAs(class$java$lang$String == null ? (class$java$lang$String = ProfileService.class$("java.lang.String")) : class$java$lang$String);
        this.log.trace((Object)"ProfileService::getManagedCard-12");
        return strSignedInformationCard.trim();
    }

    public String getProfile(IConstants constants, String strUserIdentifier, String strUserPassword, IProfile profile) throws Exception {
        this.log.trace((Object)("ProfileService::getProfile: " + strUserIdentifier));
        IContext context = null;
        if (null != strUserIdentifier && null != strUserPassword) {
            try {
                context = this.idasRegistry.createContext(this.contextId);
                context.open((IAuthNMaterials)new AuthNNamePasswordMaterials(context, strUserIdentifier, strUserPassword));
            }
            catch (Exception e) {
                throw new Exception("ERROR Invalid Username / Password");
            }
        }
        if (context == null) {
            return "ERROR Invalid Username / Password";
        }
        List listClaims = profile.getClaims();
        IEntity subj = context.getEntity(strUserIdentifier);
        for (int i = 0; i < this.listSupportedClaims.size(); ++i) {
            URI uriAttribute = (URI)this.listSupportedClaims.get(i);
            this.log.trace((Object)("Attribute: " + uriAttribute.toString()));
            Map mapAttributeClaim = (Map)this.mapAttributeClaims.get(uriAttribute.toString());
            if (null != mapAttributeClaim) {
                ISimpleValue sv;
                String strDisplayName = (String)mapAttributeClaim.get("DisplayName");
                this.log.trace((Object)("DisplayName: " + strDisplayName));
                String strAttributeName = (String)mapAttributeClaim.get("AttributeName");
                this.log.trace((Object)("AttributeName: " + strAttributeName));
                if (null == strAttributeName) continue;
                String strShortName = (String)mapAttributeClaim.get("ClaimName");
                this.log.trace((Object)("ShortName: " + strShortName));
                ClaimType claimType = new ClaimType();
                claimType.setName(uriAttribute);
                claimType.setDisplayName(strDisplayName);
                claimType.setShortName(strShortName);
                Claim claim = new Claim();
                claim.setType((IClaimType)claimType);
                ISingleValuedAttribute attr = subj.getSingleValuedAttribute(uriAttribute);
                if (attr != null && (sv = (ISimpleValue)attr.getValue()) != null) {
                    claim.addValue(sv.getLexical());
                }
                listClaims.add(claim);
                continue;
            }
            this.log.error((Object)"Attribute Not Found In AttributeClaimsMap");
        }
        context.close();
        return "Success";
    }

    public String modifyProfile(IConstants constants, String strUserIdentifier, String strUserPassword, IProfile profile) throws Exception {
        this.log.trace((Object)"ProfileService::modifyProfile");
        IContext context = null;
        if (null != strUserIdentifier && null != strUserPassword) {
            try {
                context = this.idasRegistry.createContext(this.contextId);
                context.open((IAuthNMaterials)new AuthNNamePasswordMaterials(context, strUserIdentifier, strUserPassword));
            }
            catch (Exception e) {
                throw new Exception("ERROR Invalid Username / Password");
            }
        }
        if (context == null) {
            return "ERROR Invalid Username / Password";
        }
        IEntity subj = context.getEntity(strUserIdentifier);
        List listClaims = profile.getClaims();
        int size = listClaims.size();
        this.log.trace((Object)("ProfileService::modifyProfile. Claims count " + size));
        try {
            for (int i = 0; i < size; ++i) {
                IClaim claim = (IClaim)listClaims.get(i);
                IClaimType claimType = claim.getType();
                String strShortName = claimType.getShortName();
                Iterator iterValues = claim.getValues();
                String strValue = null;
                if (iterValues.hasNext()) {
                    strValue = (String)iterValues.next();
                }
                if (null == strValue || strValue.trim().length() <= 0) continue;
                URI attributeClaimUri = (URI)this.mapShortNameClaimUri.get(strShortName);
                this.log.trace((Object)("ProfileService::modifyProfile: " + attributeClaimUri + "-" + strValue));
                ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attributeClaimUri);
                if (attr != null) {
                    attr.remove();
                }
                attr = subj.addAttribute(attributeClaimUri);
                attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)strValue);
            }
            context.applyUpdates();
            context.close();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            context.cancelUpdates();
            context.close();
            throw e;
        }
        System.out.println("ProfileService::modifyProfile. Success.");
        return "SUCCESS";
    }

    public String modifyProfileSetCardKeyHash(IConstants constants, String strUserIdentifier, String strUserPassword, String strPPID, String strModulus, String strExponent) throws Exception {
        this.log.trace((Object)"ProfileService::modifyProfileSetCardKeyHash");
        IContext context = null;
        if (null != strUserIdentifier && null != strUserPassword) {
            context = this.idasRegistry.createContext(this.contextId);
            context.open((IAuthNMaterials)new AuthNNamePasswordMaterials(context, strUserIdentifier, strUserPassword));
        }
        if (context == null) {
            return "ERROR Invalid Username / Password";
        }
        ByteArrayOutputStream cardKey = new ByteArrayOutputStream();
        cardKey.write(Base64.decodeBase64((byte[])strPPID.getBytes()));
        cardKey.write(Base64.decodeBase64((byte[])strModulus.getBytes()));
        cardKey.write(Base64.decodeBase64((byte[])strExponent.getBytes()));
        String strCardKeyHash = this.xmlSecurityExtension.SHA1Digest(cardKey.toByteArray());
        this.log.trace((Object)("CardKeyHash(in): " + strCardKeyHash));
        IEntity subj = context.getEntity(strUserIdentifier);
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(this.CARD_KEY_HASH_URI);
        if (attr != null) {
            attr.remove();
        }
        attr = subj.addAttribute(this.CARD_KEY_HASH_URI);
        attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)strCardKeyHash);
        context.applyUpdates();
        context.close();
        return "Success";
    }

    public String modifyProfileSetX509SHA(IConstants constants, String strUserIdentifier, String strUserPassword, String strX509SHA) throws Exception {
        this.log.trace((Object)"ProfileService::modifyProfileSetX509SHA");
        IContext context = null;
        if (null != strUserIdentifier && null != strUserPassword) {
            context = this.idasRegistry.createContext(this.contextId);
            context.open((IAuthNMaterials)new AuthNNamePasswordMaterials(context, strUserIdentifier, strUserPassword));
        }
        if (context == null) {
            return "ERROR Invalid Username / Password";
        }
        this.log.trace((Object)("X509 SHA(in): " + strX509SHA));
        IEntity subj = context.getEntity(strUserIdentifier);
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(this.CARD_KEY_HASH_URI);
        if (attr != null) {
            attr.remove();
        }
        attr = subj.addAttribute(this.CARD_KEY_HASH_URI);
        attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)strX509SHA);
        context.applyUpdates();
        context.close();
        return "Success";
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        this.log.trace((Object)"ProfileService::configure");
        if (this.bInitialized) {
            this.log.trace((Object)"ProfileService::configure Already Configured.");
            return;
        }
        this.mapGlobalSettings = mapGlobalSettings;
        this.strComponentName = strComponentName;
        this.mapComponentSettings = mapComponentSettings;
        this.idasRegistry = (IdASRegistry)mapGlobalSettings.get("IdentityAttributeService");
        if (this.idasRegistry == null) {
            throw new Exception("Can not get IdentityAttributeService setting");
        }
        this.log.trace((Object)("IdentityAttributeService: " + this.idasRegistry.getClass().getName()));
        this.storeUserName = (String)mapComponentSettings.get(AuthNNamePasswordMaterials.ATTR_TYPE_USERNAME.toString());
        this.storePassword = (String)mapComponentSettings.get(AuthNNamePasswordMaterials.ATTR_MANAGED_URI.toString());
        this.allowAnonymousAccess = mapComponentSettings.containsKey("AllowAnonymousAccess") ? (Boolean)mapComponentSettings.get("AllowAnonymousAccess") : false;
        FileInputStream fisCardImage = (FileInputStream)mapComponentSettings.get("CardImageFile");
        byte[] byteCardImage = new byte[fisCardImage.available()];
        fisCardImage.read(byteCardImage);
        this.strCardImage = new String(Base64.encodeBase64((byte[])byteCardImage));
        this.log.trace((Object)("CardImage: " + this.strCardImage));
        this.certSSL = (X509Certificate)mapGlobalSettings.get("SSLCertificate");
        this.xmlSecurityExtension = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
        this.listSupportedClaims = (List)mapComponentSettings.get("SupportedClaimList");
        this.mapAttributeClaims = (Map)mapGlobalSettings.get("AttributeClaimMap");
        this.mapShortNameAttribute = new Hashtable();
        this.mapShortNameClaimUri = new Hashtable();
        for (int i = 0; i < this.listSupportedClaims.size(); ++i) {
            URI uriSupportedClaim = (URI)this.listSupportedClaims.get(i);
            Map mapClaim = (Map)this.mapAttributeClaims.get(uriSupportedClaim.toString());
            String strClaimName = (String)mapClaim.get("ClaimName");
            String strAttributeName = (String)mapClaim.get("AttributeName");
            if (null == strAttributeName) continue;
            this.log.trace((Object)("Adding to ShortName Attribute Map: " + uriSupportedClaim.toString() + " " + strClaimName + "/" + strAttributeName));
            this.mapShortNameAttribute.put(strClaimName, strAttributeName);
            this.mapShortNameClaimUri.put(strClaimName, uriSupportedClaim);
        }
        if (!mapComponentSettings.containsKey("ContextId")) {
            throw new Exception("Cannot get \"ContextId\" from ProfileService setting.");
        }
        this.contextId = (String)mapComponentSettings.get("ContextId");
        if (!mapComponentSettings.containsKey("DigitalSubjectType")) {
            throw new Exception("Cannot get \"DigitalSubjectType\" ProfileService setting.");
        }
        this.digitalSubjectType = (URI)mapComponentSettings.get("DigitalSubjectType");
        this.bInitialized = true;
        this.log.trace((Object)"ProfileService::configure DONE");
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

