/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial generation from WSDL using WSDL2Java
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.profile;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.naming.Context;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IProfileService;
import org.eclipse.higgins.sts.api.IProfile;

/**
 * Binds the Axis 1.x framework generated skeleton code to the Higgins STS implementation.
 * Class was originally auto-generated from WSDL by the Apache Axis 1.3 Oct 05, 2005 (05:23:37 EDT) WSDL2Java emitter.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Find out when ProfileService instances are instantiated (singleton? instance per request? other?)
public class ProfileService implements IProfileService
{	
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(ProfileService.class.getName());

	/**
	 * Indicates whether Initialize was called successfully.
	 */
	private boolean bInitialized = false;
	
	private java.util.Map mapGlobalSettings = null;
	
//	private String strComponentName = null;
	
	private java.util.Map mapComponentSettings = null;
	
	private java.util.List listSupportedClaims = null;
	
	private java.util.Map mapAttributeClaims = null;
	
	private java.util.Map mapShortNameAttribute = null;
	
	private java.util.List listEntryObjectClass = null;
		
	private String strTrustedStore = null;
	
	private String strTrustedStorePassword = null;
	
	private java.net.URI uriLDAPProvider = null;
	
	private String strLDAPPrincipal = null;
	
	private String strLDAPCredential = null;
	
	private String strLDAPEntryPrefix = null;
	
	private String strLDAPEntrySuffix = null;
	
	private String strCardImage = null;
	
	private X509Certificate certSSL = null;
	
	private org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurityExtension = null;
	
	/**
	 *  Creates and initializes the Class. 
	 */
	protected ProfileService()
		throws Exception
	{
		this.log.trace("ProfileService::ProfileService");
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.ISecurityTokenService#configure(java.util.Map, java.util.Map, java.util.Map, java.util.Map)
	 */ 
	public synchronized void configure
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
		throws Exception
	{
		this.log.trace("ProfileService::configure");
		
		if (this.bInitialized)
		{
			this.log.trace("ProfileService::configure Already Configured.");
			return;
		}
		
		this.mapGlobalSettings = mapGlobalSettings;
//		this.strComponentName = strComponentName;
		this.mapComponentSettings = mapComponentSettings;
		
		final String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
		this.log.trace("ConfigurationBase: " + strConfigurationBase);

		this.strTrustedStore = (String)mapComponentSettings.get("LDAPTrustedStore");
		this.strTrustedStorePassword = (String)mapComponentSettings.get("LDAPTrustedStorePassword");
		
		if (null != this.strTrustedStore)
		{
			System.setProperty("javax.net.ssl.trustStore", strConfigurationBase + "/" + this.strTrustedStore);
		}
		if (null != this.strTrustedStorePassword) {
			System.setProperty("javax.net.ssl.trustStorePassword", this.strTrustedStorePassword);
		}
		
		this.uriLDAPProvider = (java.net.URI)mapComponentSettings.get("LDAPProvider");
		this.strLDAPPrincipal = (String)mapComponentSettings.get("LDAPPrincipal");
		this.strLDAPCredential = (String)mapComponentSettings.get("LDAPCredential");
		this.strLDAPEntryPrefix = (String)mapComponentSettings.get("LDAPEntryPrefix");
		this.strLDAPEntrySuffix = (String)mapComponentSettings.get("LDAPEntrySuffix");
		java.io.FileInputStream fisCardImage = (java.io.FileInputStream)mapComponentSettings.get("CardImageFile");	
		byte [] byteCardImage = new byte[fisCardImage.available()];
		fisCardImage.read(byteCardImage);
		this.strCardImage = new String(org.apache.commons.codec.binary.Base64.encodeBase64(byteCardImage));
		log.trace("CardImage: " + strCardImage);
		this.certSSL = (X509Certificate)mapGlobalSettings.get("SSLCertificate");
		this.xmlSecurityExtension = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
		this.listSupportedClaims = (java.util.List)mapComponentSettings.get("SupportedClaimList");
		this.listEntryObjectClass = (java.util.List)mapComponentSettings.get("EntryObjectClassList");
		this.mapAttributeClaims = (java.util.Map)mapGlobalSettings.get("AttributeClaimMap");
		this.mapShortNameAttribute = new java.util.Hashtable();
		
		for (int i = 0; i < this.listSupportedClaims.size(); ++i)
		{
			java.net.URI uriSupportedClaim = (java.net.URI)this.listSupportedClaims.get(i);
			java.util.Map mapClaim = (java.util.Map)this.mapAttributeClaims.get(uriSupportedClaim.toString());
			String strClaimName = (String)mapClaim.get("ClaimName");
			String strAttributeName = (String)mapClaim.get("AttributeName");
			if (null != strAttributeName)
			{
				log.trace("Adding to ShortName Attribute Map: " + uriSupportedClaim.toString() + " " + strClaimName + "/" + strAttributeName);
				this.mapShortNameAttribute.put(strClaimName, strAttributeName);
			}
		}
		
		this.bInitialized = true;
		
		this.log.trace("ProfileService::configure DONE");
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.profile.IProfileService#getManagedCard(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String getManagedCard
		(final IConstants constants,
		final String strCardName,
		final String strUsername,
		final String strPassword,
		final String strCredentialType,
		final String strRequireAppliesTo,
		final String strToken)
		throws Exception
	{
		this.log.trace("ProfileService::getManagedCard");
	
		this.log.trace("CredentialType: " + strCredentialType);
	
		String strPPID = null;
		String strModulus = null;
		String strExponent = null;
		String strThumbprint = null;
		
		boolean bRequireAppliesTo = ((null != strRequireAppliesTo) && (strRequireAppliesTo.matches("true")));
		
		if (null != strToken)
		{
	    	// TODO: Decrypt Token
	    	org.eclipse.higgins.sts.api.IElement elemToken = new org.eclipse.higgins.sts.common.Element();
	    	elemToken.set(strToken);

	    	this.log.trace("Decrypting Security Token");
	    	final org.eclipse.higgins.sts.api.IElement elemDecryptedToken = this.xmlSecurityExtension.DecryptElement
	    		(elemToken,
	    		(PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
	    	this.log.trace("Decrypted Security Token: " + (String)elemDecryptedToken.getAs(String.class));
	    	this.log.trace("Looking for the PPID");
	    	
	    	org.w3c.dom.Element domDecryptedToken = (org.w3c.dom.Element)elemDecryptedToken.getAs(org.w3c.dom.Element.class);
	    	
	    	final org.w3c.dom.NodeList nlAttributes = domDecryptedToken.getElementsByTagNameNS
	    		(constants.getSAML10AssertionNamespace().toString(),
	    		"Attribute");
			if (null == nlAttributes)
			{
				this.log.trace("No Attribute found (getElementsByTagName returned null)");
			}
			else if (0 == nlAttributes.getLength())
			{
				this.log.trace("No Attribute found (0 == getLength())");
			}
			else
			{
				for (int i = 0; i < nlAttributes.getLength(); ++i)
				{
					this.log.trace("Processing Attribute element");
					final org.w3c.dom.Element elemAttribute = (org.w3c.dom.Element)nlAttributes.item(i);
					final String strAttributeName = elemAttribute.getAttribute("AttributeName");
					this.log.trace("Attribute: " + strAttributeName);
					if (strAttributeName.matches("privatepersonalidentifier"))
					{
				    	final org.w3c.dom.NodeList nlAttributeValues = elemAttribute.getElementsByTagNameNS
				    		(constants.getSAML10AssertionNamespace().toString(), "AttributeValue");
						if (null == nlAttributeValues)
						{
							this.log.trace("No AttributeValue found (getElementsByTagName returned null)");
						}
						else if (0 == nlAttributeValues.getLength())
						{
							this.log.trace("No AttributeValue found (0 == getLength())");
						}
						else if (1 != nlAttributeValues.getLength())
						{
							this.log.trace("More than 1 AttributeValue found");
						}
						else
						{
							final org.w3c.dom.Element elemAttributeValue = (org.w3c.dom.Element)nlAttributeValues.item(0);
							strPPID = org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(elemAttributeValue);
							this.log.trace("PPID: " + strPPID);
							break;
						}
					}		
				}
			}
	
	    	final org.w3c.dom.NodeList nlModuluses = domDecryptedToken.getElementsByTagNameNS
	    		(constants.getXMLSignatureNamespace().toString(), "Modulus");
			if (null == nlModuluses)
			{
				this.log.trace("No Modulus found (getElementsByTagName returned null)");
			}
			else if (0 == nlModuluses.getLength())
			{
				this.log.trace("No Modulus found (0 == getLength())");
			}
			else
			{
				this.log.trace("Processing Modulus element");
				final org.w3c.dom.Element elemModulus = (org.w3c.dom.Element)nlModuluses.item(0);
				strModulus = org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(elemModulus);
				this.log.trace("Modulus: " + strModulus);
			}
			final org.w3c.dom.NodeList nlExponents = domDecryptedToken.getElementsByTagNameNS
	    		(constants.getXMLSignatureNamespace().toString(), "Exponent");
			if (null == nlExponents)
			{
				this.log.trace("No Exponent found (getElementsByTagName returned null)");
			}
			else if (0 == nlExponents.getLength())
			{
				this.log.trace("No Exponent found (0 == getLength())");
			}
			else
			{
				this.log.trace("Processing Exponent element");
				final org.w3c.dom.Element elemExponent = (org.w3c.dom.Element)nlExponents.item(0);
				strExponent = org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(elemExponent);
				this.log.trace("Exponent: " + strExponent);
			}
	
			final String strResult = this.modifyProfileSetCardKeyHash
				(constants,
			    strUsername,
				strPassword,
				strPPID,
				strModulus,
				strExponent);
			if (!strResult.matches("Success"))
			{
				return strResult;
			}
		}

		log.trace("ProfileService::getManagedCard-0");
		
		final String strSSLCertificate = new String
			(org.apache.commons.codec.binary.Base64.encodeBase64
					(this.certSSL.getEncoded()));
		
		log.trace("ProfileService::getManagedCard-1");

		final String strEscapedCardName = strCardName.replaceAll(" ", "-");
		
		log.trace("ProfileService::getManagedCard-2");

	    final String strId = "IC01";
	    
		log.trace("ProfileService::getManagedCard-3");

	    String strInformationCard =
	    	"<InformationCard xmlns=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xml:lang=\"en-us\">"
	    	+ "<InformationCardReference>"
	    	+ "<CardId>" + ((java.net.URI)this.mapComponentSettings.get("CardId")).toString() + "&amp;cardid=" + strEscapedCardName + "</CardId>"
	    	+ "<CardVersion>1</CardVersion>"
	    	+ "</InformationCardReference>"
	    	+ "<CardName>" + strCardName + "</CardName>"
	    	+ "<CardImage MimeType=\"image/jpeg\">" + this.strCardImage + "</CardImage>"
	    	+ "<Issuer>" + ((java.net.URI)this.mapGlobalSettings.get("TokenServiceIssuerURI")).toString() + "</Issuer>"
	    	+ "<TimeIssued>2006-10-28T00:00:00.999Z</TimeIssued>"
	    	+ "<TimeExpires>9999-12-31T23:59:59.9999999Z</TimeExpires>"
	    	+ "<TokenServiceList>"
	    	+ "<TokenService>"
	    	+ "<EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">"
	    	+ "<Address>" + ((java.net.URI)this.mapGlobalSettings.get("TokenServiceTrustURI")).toString() + "</Address>"
	    	+ "<Metadata>"
	    	+ "<Metadata xmlns=\"http://schemas.xmlsoap.org/ws/2004/09/mex\">"
	    	+ "<MetadataSection>"
	    	+ "<MetadataReference>"
	    	+ "<Address xmlns=\"http://www.w3.org/2005/08/addressing\">";
	    
		log.trace("ProfileService::getManagedCard-4");
	    
	    if (strCredentialType.matches("UsernamePassword"))
	    {
	    	this.log.trace("MetadataURI: " + ((java.net.URI)this.mapGlobalSettings.get("UsernameTokenMetadataURI")).toString());
	    	strInformationCard += ((java.net.URI)this.mapGlobalSettings.get("UsernameTokenMetadataURI")).toString();
	    }
	    else if (strCredentialType.matches("SelfSignedSAML"))
	    {
	    	this.log.trace("MetadataURI: " + ((java.net.URI)this.mapGlobalSettings.get("SelfSignedSAMLTokenMetadataURI")).toString());
		    strInformationCard += ((java.net.URI)this.mapGlobalSettings.get("SelfSignedSAMLTokenMetadataURI")).toString();
	    }
	    else if (strCredentialType.startsWith("X509"))
	    {
	    	strThumbprint = strCredentialType.substring("X509".length());
	    	this.log.trace("MetadataURI: " + ((java.net.URI)this.mapGlobalSettings.get("X509TokenMetadataURI")).toString());
		    strInformationCard += ((java.net.URI)this.mapGlobalSettings.get("X509TokenMetadataURI")).toString();
	    }
	    else
	    {
	    	this.log.trace("MetadataURI NOT Added");
	    }
	    
		log.trace("ProfileService::getManagedCard-5");

	    strInformationCard += "</Address>"
	    	+ "</MetadataReference>"
	    	+ "</MetadataSection>"
	    	+ "</Metadata>"
	    	+ "</Metadata>"
	    	+ "<Identity xmlns=\"http://schemas.xmlsoap.org/ws/2006/02/addressingidentity\">"
	    	+ "<KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">"
	    	+ "<X509Data>"
	    	+ "<X509Certificate>" + strSSLCertificate + "</X509Certificate>"
	    	+ "</X509Data>"
	    	+ "</KeyInfo>"
	    	+ "</Identity>"
	        + "</EndpointReference>"
	        + "<UserCredential>";
	    
		log.trace("ProfileService::getManagedCard-6");

	    if (strCredentialType.matches("UsernamePassword"))
	    {
		    strInformationCard +=
		        "<DisplayCredentialHint>Enter your username and password</DisplayCredentialHint>"
		        + "<UsernamePasswordCredential>"
		        + "<Username>" + strUsername + "</Username>"
		        + "</UsernamePasswordCredential>";
	    }
	    else if (strCredentialType.matches("SelfSignedSAML"))
	    {
		    strInformationCard +=
		        "<SelfIssuedCredential>"
		    	+ "<PrivatePersonalIdentifier>"
		    	+ strPPID
		    	+ "</PrivatePersonalIdentifier>"
		    	+ "</SelfIssuedCredential>";
	    }
	    else if (strCredentialType.startsWith("X509"))
	    {
	    	// we're going to record the cert in the user's profile
			final String strResult = this.modifyProfileSetX509SHA
			(constants,
		    strUsername,
			strPassword,
			strThumbprint);
			if (!strResult.matches("Success"))
			{
				return strResult;
			}

		    strInformationCard +=
		        "<X509V3Credential>"
		    	+ "<ds:X509Data xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">"
		    	+ "<KeyIdentifier xmlns=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" ValueType=\"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1\" EncodingType=\"http://docs.oasis-open.org/wss/2004/01/oasis200401-wss-soap-message-security-1.0#Base64Binary\">"
		    	+ strThumbprint
		    	+ "</KeyIdentifier>"
		    	+ "</ds:X509Data>"
		    	+ "</X509V3Credential>"
		    	;
	    }

	    
		log.trace("ProfileService::getManagedCard-7");
	
	    // TODO: Make this list of SupportClaimTypes configurable
	    strInformationCard +=
	    	"</UserCredential>"
	    	+ "</TokenService>"
	        + "</TokenServiceList>"
	        + "<SupportedTokenTypeList>"
	        + "<TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1</TokenType>"
	        + "<TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0</TokenType>"
	        + "<TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">urn:oasis:names:tc:SAML:1.0:assertion</TokenType>"
	        + "<TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">urn:oasis:names:tc:SAML:2.0:assertion</TokenType>"
	        + "</SupportedTokenTypeList>"
	        + "<SupportedClaimTypeList>";
	    
		for (int i = 0; i < this.listSupportedClaims.size(); ++i)
		{
			final java.net.URI uriAttribute = (java.net.URI)this.listSupportedClaims.get(i);
			log.trace("Attribute: " + uriAttribute.toString());
			final java.util.Map mapAttributeClaim = (java.util.Map)this.mapAttributeClaims.get(uriAttribute.toString());
			if (null != mapAttributeClaim)
			{
				final String strDisplayName = (String)mapAttributeClaim.get("DisplayName");
				log.trace("DisplayName: " + strDisplayName);
				strInformationCard +=
					"<SupportedClaimType Uri=\"" + uriAttribute.toString() + "\">" 
					+ "<DisplayTag>" + strDisplayName + "</DisplayTag>"
					+ "<Description>" + strDisplayName + "</Description>"
					+ "</SupportedClaimType>";
			}
		}
	        
	    strInformationCard +=	        
	        "</SupportedClaimTypeList>"
	        + (bRequireAppliesTo ? "<RequireAppliesTo/>" : "")
	        + "</InformationCard>";
	    
		log.trace("ProfileService::getManagedCard-8");
	    
	    final org.eclipse.higgins.sts.api.IElement elemInformationCard = new org.eclipse.higgins.sts.common.Element();
	    
		log.trace("ProfileService::getManagedCard-9");

	    elemInformationCard.set(strInformationCard);
	    
		log.trace("ProfileService::getManagedCard-10");

	    final org.eclipse.higgins.sts.api.IElement elemSignedInformationCard = this.xmlSecurityExtension.SignEnveloping
	    	(elemInformationCard,
	    	strId,
	    	(X509Certificate)this.mapGlobalSettings.get("IssuerCertificate"),
	    	(PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
		
	    log.trace("ProfileService::getManagedCard-11");

		final String strSignedInformationCard = (String)elemSignedInformationCard.getAs(String.class);
		
		log.trace("ProfileService::getManagedCard-12");

	    return strSignedInformationCard.trim();
	}
	
	private javax.naming.directory.DirContext getContext
		(final java.net.URI uriProvider,
		final String strPrincipal,
		final String strCredential,
		final String strTrustedStore,
		final String strTrustedStorePassword)
		throws Exception
	{
		log.trace("getContext: " + strPrincipal + "/" + strCredential);
		
		final java.util.Hashtable htEnv = new java.util.Hashtable();
		htEnv.put
			(javax.naming.Context.INITIAL_CONTEXT_FACTORY,
			"com.sun.jndi.ldap.LdapCtxFactory");
		htEnv.put
			(javax.naming.Context.PROVIDER_URL,
			uriProvider.toString());
		htEnv.put
			(javax.naming.Context.SECURITY_AUTHENTICATION,
			"simple");
		htEnv.put
			(javax.naming.Context.SECURITY_PRINCIPAL,
			strPrincipal);
		htEnv.put
			(javax.naming.Context.SECURITY_CREDENTIALS,
			strCredential);
		htEnv.put
			("java.naming.ldap.attributes.binary",
			"GUID cardKey");
		return new javax.naming.directory.InitialDirContext
			(htEnv);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.profile.IProfileService#createProfile(java.lang.String, java.lang.String)
	 */
	public String createProfile
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword)
		throws Exception
	{
		final javax.naming.directory.DirContext context = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPPrincipal,
			this.strLDAPCredential,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		final Attributes attributesAdd = new BasicAttributes
			(true); 
		final javax.naming.directory.Attribute objectClass = new BasicAttribute
			("objectclass");
		for (int i = 0; i < listEntryObjectClass.size(); ++i)
		{
			String strObjectClass = (String)listEntryObjectClass.get(i);
			objectClass.add(strObjectClass);
		}
		attributesAdd.put(objectClass);
		final javax.naming.directory.Attribute commonName = new BasicAttribute
			("cn");
		commonName.add(strUserIdentifier);
		attributesAdd.put(commonName);
		final javax.naming.directory.Attribute surname = new BasicAttribute
			("sn");
		surname.add(" ");
		attributesAdd.put(surname);
		final javax.naming.directory.Attribute userId = new BasicAttribute
			("uid");
		userId.add(strUserIdentifier);
		attributesAdd.put(userId);
		final javax.naming.directory.Attribute userPassword = new BasicAttribute
			("userPassword");
		userPassword.add(strUserPassword);
		attributesAdd.put(userPassword);	
		final Context subcontext = context.createSubcontext
			(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
			attributesAdd);
		return "Success";
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.profile.IProfileService#getProfile(java.lang.String, java.lang.String, org.eclipse.higgins.sts.common.IProfile)
	 */
	public String getProfile
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword,
		final IProfile profile)
		throws Exception
	{	
		log.trace("org.eclipse.higgins.sts.server.profile.IProfileService#getProfile: " + strUserIdentifier);
		
		final java.util.List listClaims = profile.getClaims();
		javax.naming.directory.DirContext context = null;
		if ((null != strUserIdentifier) && (null != strUserPassword))
		{
			context = this.getContext
				(this.uriLDAPProvider,
				this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
				strUserPassword,
				this.strTrustedStore,
				this.strTrustedStorePassword);
		}
		if (null == context)
		{
			return "ERROR Invalid Username / Password";
		}
		
		Attributes attributesOut = null;
		if (null != context)
		{
			attributesOut = context.getAttributes
				(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix);
		}
		for (int i = 0; i < this.listSupportedClaims.size(); ++i)
		{
			final java.net.URI uriAttribute = (java.net.URI)this.listSupportedClaims.get(i);
			log.trace("Attribute: " + uriAttribute.toString());
			final java.util.Map mapAttributeClaim = (java.util.Map)this.mapAttributeClaims.get(uriAttribute.toString());
			if (null != mapAttributeClaim)
			{
				final String strDisplayName = (String)mapAttributeClaim.get("DisplayName");
				log.trace("DisplayName: " + strDisplayName);
				final String strAttributeName = (String)mapAttributeClaim.get("AttributeName");
				log.trace("AttributeName: " + strAttributeName);
				if (null != strAttributeName)
				{
					final String strShortName = (String)mapAttributeClaim.get("ClaimName");
					log.trace("ShortName: " + strShortName);
					final org.eclipse.higgins.sts.api.IClaimType claimType = new org.eclipse.higgins.sts.common.ClaimType();
					claimType.setName(uriAttribute);
					claimType.setDisplayName(strDisplayName);
					claimType.setShortName(strShortName);
					final org.eclipse.higgins.sts.api.IClaim claim = new org.eclipse.higgins.sts.common.Claim();
					claim.setType(claimType);
					if ((null != strAttributeName) && (null != attributesOut))
					{
						final javax.naming.directory.Attribute attribute = attributesOut.get(strAttributeName);
						if (null != attribute)
						{
							final javax.naming.NamingEnumeration enumValues = attribute.getAll();
							while (enumValues.hasMore())
							{
								final String strValue = (String)enumValues.next();
								log.trace("Value: " + strValue);
								claim.addValue(strValue);
							}
						}
					}
					listClaims.add(claim);
				}
			}
			else
			{
				log.error("Attribute Not Found In AttributeClaimsMap");
			}
		}
		return "Success";
	}
	
	private void addStringAttribute
		(final Attributes attributesModify,
		final String strName,
		final String strValue)
	{
		if (null != strValue)
		{
			if (0 != strValue.length())
			{
				this.log.trace("addStringAttribute: " + strName + " : " + strValue);
				
				final javax.naming.directory.Attribute attribute = new BasicAttribute
					(strName);
				attribute.add(strValue);
				attributesModify.put(attribute);
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.profile.IProfileService#deleteProfile(java.lang.String, java.lang.String)
	 */
	public String deleteProfile
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword)
		throws Exception
	{
		final javax.naming.directory.DirContext contextUser = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
			strUserPassword,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		if (null == contextUser)
		{
			return "ERROR Invalid Username / Password";
		}
		final Attributes attributesOut = contextUser.getAttributes
			(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix);
		final javax.naming.directory.DirContext context = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPPrincipal,
			this.strLDAPCredential,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		context.destroySubcontext
			(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix);	
		return "Success";
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.profile.IProfileService#modifyProfileSetCardKeyHash(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String modifyProfileSetCardKeyHash
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword,
		final String strPPID,
		final String strModulus,
		final String strExponent)
		throws Exception
	{	
		final javax.naming.directory.DirContext contextUser = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
			strUserPassword,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		if (null == contextUser)
		{
			return "ERROR Invalid Username / Password";
		}
		
		final Attributes attributesOut = contextUser.getAttributes
			(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix);
		final javax.naming.directory.DirContext context = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPPrincipal,
			this.strLDAPCredential,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		final Attributes attributesModify = new BasicAttributes
			(true);
		final java.io.ByteArrayOutputStream cardKey = new java.io.ByteArrayOutputStream();

		cardKey.write
			(org.apache.commons.codec.binary.Base64.decodeBase64
				(strPPID.getBytes()));	
		cardKey.write
			(org.apache.commons.codec.binary.Base64.decodeBase64
				(strModulus.getBytes()));	
		cardKey.write
			(org.apache.commons.codec.binary.Base64.decodeBase64
				(strExponent.getBytes()));
		final String strCardKeyHash = this.xmlSecurityExtension.SHA1Digest
			(cardKey.toByteArray());
		this.log.trace("CardKeyHash(in): " + strCardKeyHash);
		this.addStringAttribute(attributesModify, "cardKeyHash", strCardKeyHash);
		context.modifyAttributes
			(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
			javax.naming.directory.DirContext.ADD_ATTRIBUTE,
			attributesModify);
		return "Success";
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.profile.IProfileService#modifyProfileSetX509SHA(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String modifyProfileSetX509SHA
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword,
		final String strX509SHA)
		throws Exception
	{	
		final javax.naming.directory.DirContext contextUser = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
			strUserPassword,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		if (null == contextUser)
		{
			return "ERROR Invalid Username / Password";
		}
		
//		final Attributes attributesOut = contextUser.getAttributes
//			(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix);
//		int operation = javax.naming.directory.DirContext.REPLACE_ATTRIBUTE;
//		if (attributesOut.get("X509SHA") == null)
//			operation = javax.naming.directory.DirContext.ADD_ATTRIBUTE;
		final javax.naming.directory.DirContext context = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPPrincipal,
			this.strLDAPCredential,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		final Attributes attributesModify = new BasicAttributes
			(true);
		this.log.trace("X509 SHA(in): " + strX509SHA);
		this.addStringAttribute(attributesModify, "cardKeyHash", strX509SHA);
		context.modifyAttributes
			(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
			javax.naming.directory.DirContext.ADD_ATTRIBUTE,
			attributesModify);
		return "Success";
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.profile.IProfileService#modifyProfile(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String modifyProfile
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword,
		final IProfile profile)
	 	throws Exception
	{
		log.trace("ProfileService::modifyProfile");
		
		final javax.naming.directory.DirContext contextUser = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
			strUserPassword,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		if (null == contextUser)
		{
			return "ERROR Invalid Username / Password";
		}
		
		final Attributes attributesOut = contextUser.getAttributes
			(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix);

		final javax.naming.directory.DirContext context = this.getContext
			(this.uriLDAPProvider,
			this.strLDAPPrincipal,
			this.strLDAPCredential,
			this.strTrustedStore,
			this.strTrustedStorePassword);
		final Attributes attributesModify = new BasicAttributes(true);
		
		final java.util.List listClaims = profile.getClaims();
		for (int i = 0; i < listClaims.size(); ++i)
		{
			final org.eclipse.higgins.sts.api.IClaim claim = (org.eclipse.higgins.sts.api.IClaim)listClaims.get(i);
			final org.eclipse.higgins.sts.api.IClaimType claimType = claim.getType();
			final String strShortName = claimType.getShortName();
			java.util.Iterator iterValues = claim.getValues();
			String strValue = null;
			if (iterValues.hasNext())
				strValue = (String)iterValues.next();
			if (null != strValue)
			{
				String strAttributeName = (String)this.mapShortNameAttribute.get(strShortName);
				log.trace("ProfileService::modifyProfile: " + strAttributeName + "-" + strValue);
				this.addStringAttribute(attributesModify, strAttributeName, strValue);
			}
		}
		if (0 != listClaims.size())
		{
			context.modifyAttributes
				(this.strLDAPEntryPrefix + strUserIdentifier + this.strLDAPEntrySuffix,
				javax.naming.directory.DirContext.REPLACE_ATTRIBUTE,
				attributesModify);
		}
		return "Success";
	}

	public String decryptToken
		(final IConstants constants,
		String strToken) 
		throws Exception
	{
		log.trace("org.eclipse.higgins.sts.server.profile.IProfileService#decryptToken");
		
		if (null != strToken)
		{
	    	// TODO: Decrypt Token
	    	org.eclipse.higgins.sts.api.IElement elemToken = new org.eclipse.higgins.sts.common.Element();
	    	elemToken.set(strToken);

	    	this.log.trace("Decrypting Security Token");
	    	final org.eclipse.higgins.sts.api.IElement elemDecryptedToken = this.xmlSecurityExtension.DecryptElement
	    		(elemToken,
	    		(PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
	    	final String strResult = (String)elemDecryptedToken.getAs(String.class);
	    	this.log.trace("Decrypted Security Token: " + strResult);
	    	return strResult;
		}

		return "Success";
	}
	
	public ISettingDescriptor getComponentDescriptor() {
		return null;
	}
}