/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.profile;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.api.IClaim;
import org.eclipse.higgins.sts.api.IClaimType;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IProfile;
import org.eclipse.higgins.sts.api.IProfileService;
import org.eclipse.higgins.sts.common.Claim;
import org.eclipse.higgins.sts.common.ClaimType;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.NodeList;

public class ProfileService
implements IProfileService {
    private final LogHelper log;
    private boolean bInitialized;
    private Map mapGlobalSettings;
    private Map mapComponentSettings;
    private List listSupportedClaims;
    private Map mapAttributeClaims;
    private Map mapShortNameAttribute;
    private List listEntryObjectClass;
    private String strTrustedStore;
    private String strTrustedStorePassword;
    private URI uriLDAPProvider;
    private String strLDAPPrincipal;
    private String strLDAPCredential;
    private String strLDAPEntryPrefix;
    private String strLDAPEntrySuffix;
    private String strCardImage;
    private X509Certificate certSSL;
    private IXMLSecurityExtension xmlSecurityExtension;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected ProfileService() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.server.profile.ProfileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.bInitialized = false;
        this.mapGlobalSettings = null;
        this.mapComponentSettings = null;
        this.listSupportedClaims = null;
        this.mapAttributeClaims = null;
        this.mapShortNameAttribute = null;
        this.listEntryObjectClass = null;
        this.strTrustedStore = null;
        this.strTrustedStorePassword = null;
        this.uriLDAPProvider = null;
        this.strLDAPPrincipal = null;
        this.strLDAPCredential = null;
        this.strLDAPEntryPrefix = null;
        this.strLDAPEntrySuffix = null;
        this.strCardImage = null;
        this.certSSL = null;
        this.xmlSecurityExtension = null;
        this.log.trace((Object)"ProfileService::ProfileService");
    }

    public synchronized void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        this.log.trace((Object)"ProfileService::configure");
        if (this.bInitialized) {
            this.log.trace((Object)"ProfileService::configure Already Configured.");
            return;
        }
        this.mapGlobalSettings = mapGlobalSettings;
        this.mapComponentSettings = mapComponentSettings;
        String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
        this.log.trace((Object)("ConfigurationBase: " + strConfigurationBase));
        this.strTrustedStore = (String)mapComponentSettings.get("LDAPTrustedStore");
        this.strTrustedStorePassword = (String)mapComponentSettings.get("LDAPTrustedStorePassword");
        if (this.strTrustedStore != null) {
            System.setProperty("javax.net.ssl.trustStore", String.valueOf(strConfigurationBase) + "/" + this.strTrustedStore);
        }
        if (this.strTrustedStorePassword != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", this.strTrustedStorePassword);
        }
        this.uriLDAPProvider = (URI)mapComponentSettings.get("LDAPProvider");
        this.strLDAPPrincipal = (String)mapComponentSettings.get("LDAPPrincipal");
        this.strLDAPCredential = (String)mapComponentSettings.get("LDAPCredential");
        this.strLDAPEntryPrefix = (String)mapComponentSettings.get("LDAPEntryPrefix");
        this.strLDAPEntrySuffix = (String)mapComponentSettings.get("LDAPEntrySuffix");
        FileInputStream fisCardImage = (FileInputStream)mapComponentSettings.get("CardImageFile");
        byte[] byteCardImage = new byte[fisCardImage.available()];
        fisCardImage.read(byteCardImage);
        this.strCardImage = new String(Base64.encodeBase64((byte[])byteCardImage));
        this.log.trace((Object)("CardImage: " + this.strCardImage));
        this.certSSL = (X509Certificate)mapGlobalSettings.get("SSLCertificate");
        this.xmlSecurityExtension = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
        this.listSupportedClaims = (List)mapComponentSettings.get("SupportedClaimList");
        this.listEntryObjectClass = (List)mapComponentSettings.get("EntryObjectClassList");
        this.mapAttributeClaims = (Map)mapGlobalSettings.get("AttributeClaimMap");
        this.mapShortNameAttribute = new Hashtable();
        int i = 0;
        while (i < this.listSupportedClaims.size()) {
            URI uriSupportedClaim = (URI)this.listSupportedClaims.get(i);
            Map mapClaim = (Map)this.mapAttributeClaims.get(uriSupportedClaim.toString());
            String strClaimName = (String)mapClaim.get("ClaimName");
            String strAttributeName = (String)mapClaim.get("AttributeName");
            if (strAttributeName != null) {
                this.log.trace((Object)("Adding to ShortName Attribute Map: " + uriSupportedClaim.toString() + " " + strClaimName + "/" + strAttributeName));
                this.mapShortNameAttribute.put(strClaimName, strAttributeName);
            }
            ++i;
        }
        this.bInitialized = true;
        this.log.trace((Object)"ProfileService::configure DONE");
    }

    public String getManagedCard(IConstants constants, String strCardName, String strUsername, String strPassword, String strCredentialType, String strRequireAppliesTo, String strToken) throws Exception {
        boolean bRequireAppliesTo;
        this.log.trace((Object)"ProfileService::getManagedCard");
        this.log.trace((Object)("CredentialType: " + strCredentialType));
        String strPPID = null;
        String strModulus = null;
        String strExponent = null;
        String strThumbprint = null;
        boolean bl = bRequireAppliesTo = strRequireAppliesTo != null && strRequireAppliesTo.matches("true");
        if (strToken != null) {
            org.w3c.dom.Element domDecryptedToken;
            NodeList nlAttributes;
            Element elemToken = new Element();
            elemToken.set((Object)strToken);
            this.log.trace((Object)"Decrypting Security Token");
            IElement elemDecryptedToken = this.xmlSecurityExtension.DecryptElement((IElement)elemToken, (PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
            StringBuffer stringBuffer = new StringBuffer("Decrypted Security Token: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log.trace((Object)stringBuffer.append((String)elemDecryptedToken.getAs((Class)clazz)).toString());
            this.log.trace((Object)"Looking for the PPID");
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.w3c.dom.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((nlAttributes = (domDecryptedToken = (org.w3c.dom.Element)elemDecryptedToken.getAs((Class)clazz2)).getElementsByTagNameNS(constants.getSAML10AssertionNamespace().toString(), "Attribute")) == null) {
                this.log.trace((Object)"No Attribute found (getElementsByTagName returned null)");
            } else if (nlAttributes.getLength() == 0) {
                this.log.trace((Object)"No Attribute found (0 == getLength())");
            } else {
                int i = 0;
                while (i < nlAttributes.getLength()) {
                    this.log.trace((Object)"Processing Attribute element");
                    org.w3c.dom.Element elemAttribute = (org.w3c.dom.Element)nlAttributes.item(i);
                    String strAttributeName = elemAttribute.getAttribute("AttributeName");
                    this.log.trace((Object)("Attribute: " + strAttributeName));
                    if (strAttributeName.matches("privatepersonalidentifier")) {
                        NodeList nlAttributeValues = elemAttribute.getElementsByTagNameNS(constants.getSAML10AssertionNamespace().toString(), "AttributeValue");
                        if (nlAttributeValues == null) {
                            this.log.trace((Object)"No AttributeValue found (getElementsByTagName returned null)");
                        } else if (nlAttributeValues.getLength() == 0) {
                            this.log.trace((Object)"No AttributeValue found (0 == getLength())");
                        } else if (1 != nlAttributeValues.getLength()) {
                            this.log.trace((Object)"More than 1 AttributeValue found");
                        } else {
                            org.w3c.dom.Element elemAttributeValue = (org.w3c.dom.Element)nlAttributeValues.item(0);
                            strPPID = XMLHelper.getTextContent((org.w3c.dom.Element)elemAttributeValue);
                            this.log.trace((Object)("PPID: " + strPPID));
                            break;
                        }
                    }
                    ++i;
                }
            }
            NodeList nlModuluses = domDecryptedToken.getElementsByTagNameNS(constants.getXMLSignatureNamespace().toString(), "Modulus");
            if (nlModuluses == null) {
                this.log.trace((Object)"No Modulus found (getElementsByTagName returned null)");
            } else if (nlModuluses.getLength() == 0) {
                this.log.trace((Object)"No Modulus found (0 == getLength())");
            } else {
                this.log.trace((Object)"Processing Modulus element");
                org.w3c.dom.Element elemModulus = (org.w3c.dom.Element)nlModuluses.item(0);
                strModulus = XMLHelper.getTextContent((org.w3c.dom.Element)elemModulus);
                this.log.trace((Object)("Modulus: " + strModulus));
            }
            NodeList nlExponents = domDecryptedToken.getElementsByTagNameNS(constants.getXMLSignatureNamespace().toString(), "Exponent");
            if (nlExponents == null) {
                this.log.trace((Object)"No Exponent found (getElementsByTagName returned null)");
            } else if (nlExponents.getLength() == 0) {
                this.log.trace((Object)"No Exponent found (0 == getLength())");
            } else {
                this.log.trace((Object)"Processing Exponent element");
                org.w3c.dom.Element elemExponent = (org.w3c.dom.Element)nlExponents.item(0);
                strExponent = XMLHelper.getTextContent((org.w3c.dom.Element)elemExponent);
                this.log.trace((Object)("Exponent: " + strExponent));
            }
            String strResult = this.modifyProfileSetCardKeyHash(constants, strUsername, strPassword, strPPID, strModulus, strExponent);
            if (!strResult.matches("Success")) {
                return strResult;
            }
        }
        this.log.trace((Object)"ProfileService::getManagedCard-0");
        String strSSLCertificate = new String(Base64.encodeBase64((byte[])this.certSSL.getEncoded()));
        this.log.trace((Object)"ProfileService::getManagedCard-1");
        String strEscapedCardName = strCardName.replaceAll(" ", "-");
        this.log.trace((Object)"ProfileService::getManagedCard-2");
        this.log.trace((Object)"ProfileService::getManagedCard-3");
        String strInformationCard = "<InformationCard xmlns=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xml:lang=\"en-us\"><InformationCardReference><CardId>" + ((URI)this.mapComponentSettings.get("CardId")).toString() + "&amp;cardid=" + strEscapedCardName + "</CardId>" + "<CardVersion>1</CardVersion>" + "</InformationCardReference>" + "<CardName>" + strCardName + "</CardName>" + "<CardImage MimeType=\"image/jpeg\">" + this.strCardImage + "</CardImage>" + "<Issuer>" + ((URI)this.mapGlobalSettings.get("TokenServiceIssuerURI")).toString() + "</Issuer>" + "<TimeIssued>2006-10-28T00:00:00.999Z</TimeIssued>" + "<TimeExpires>9999-12-31T23:59:59.9999999Z</TimeExpires>" + "<TokenServiceList>" + "<TokenService>" + "<EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">" + "<Address>" + ((URI)this.mapGlobalSettings.get("TokenServiceTrustURI")).toString() + "</Address>" + "<Metadata>" + "<Metadata xmlns=\"http://schemas.xmlsoap.org/ws/2004/09/mex\">" + "<MetadataSection>" + "<MetadataReference>" + "<Address xmlns=\"http://www.w3.org/2005/08/addressing\">";
        this.log.trace((Object)"ProfileService::getManagedCard-4");
        if (strCredentialType.matches("UsernamePassword")) {
            this.log.trace((Object)("MetadataURI: " + ((URI)this.mapGlobalSettings.get("UsernameTokenMetadataURI")).toString()));
            strInformationCard = String.valueOf(strInformationCard) + ((URI)this.mapGlobalSettings.get("UsernameTokenMetadataURI")).toString();
        } else if (strCredentialType.matches("SelfSignedSAML")) {
            this.log.trace((Object)("MetadataURI: " + ((URI)this.mapGlobalSettings.get("SelfSignedSAMLTokenMetadataURI")).toString()));
            strInformationCard = String.valueOf(strInformationCard) + ((URI)this.mapGlobalSettings.get("SelfSignedSAMLTokenMetadataURI")).toString();
        } else if (strCredentialType.startsWith("X509")) {
            strThumbprint = strCredentialType.substring("X509".length());
            this.log.trace((Object)("MetadataURI: " + ((URI)this.mapGlobalSettings.get("X509TokenMetadataURI")).toString()));
            strInformationCard = String.valueOf(strInformationCard) + ((URI)this.mapGlobalSettings.get("X509TokenMetadataURI")).toString();
        } else {
            this.log.trace((Object)"MetadataURI NOT Added");
        }
        this.log.trace((Object)"ProfileService::getManagedCard-5");
        strInformationCard = String.valueOf(strInformationCard) + "</Address></MetadataReference></MetadataSection></Metadata></Metadata><Identity xmlns=\"http://schemas.xmlsoap.org/ws/2006/02/addressingidentity\"><KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\"><X509Data><X509Certificate>" + strSSLCertificate + "</X509Certificate>" + "</X509Data>" + "</KeyInfo>" + "</Identity>" + "</EndpointReference>" + "<UserCredential>";
        this.log.trace((Object)"ProfileService::getManagedCard-6");
        if (strCredentialType.matches("UsernamePassword")) {
            strInformationCard = String.valueOf(strInformationCard) + "<DisplayCredentialHint>Enter your username and password</DisplayCredentialHint><UsernamePasswordCredential><Username>" + strUsername + "</Username>" + "</UsernamePasswordCredential>";
        } else if (strCredentialType.matches("SelfSignedSAML")) {
            strInformationCard = String.valueOf(strInformationCard) + "<SelfIssuedCredential><PrivatePersonalIdentifier>" + strPPID + "</PrivatePersonalIdentifier>" + "</SelfIssuedCredential>";
        } else if (strCredentialType.startsWith("X509")) {
            String strResult = this.modifyProfileSetX509SHA(constants, strUsername, strPassword, strThumbprint);
            if (!strResult.matches("Success")) {
                return strResult;
            }
            strInformationCard = String.valueOf(strInformationCard) + "<X509V3Credential><ds:X509Data xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><KeyIdentifier xmlns=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" ValueType=\"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1\" EncodingType=\"http://docs.oasis-open.org/wss/2004/01/oasis200401-wss-soap-message-security-1.0#Base64Binary\">" + strThumbprint + "</KeyIdentifier>" + "</ds:X509Data>" + "</X509V3Credential>";
        }
        this.log.trace((Object)"ProfileService::getManagedCard-7");
        strInformationCard = String.valueOf(strInformationCard) + "</UserCredential></TokenService></TokenServiceList><SupportedTokenTypeList><TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1</TokenType><TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0</TokenType><TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">urn:oasis:names:tc:SAML:1.0:assertion</TokenType><TokenType xmlns=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">urn:oasis:names:tc:SAML:2.0:assertion</TokenType></SupportedTokenTypeList><SupportedClaimTypeList>";
        int i = 0;
        while (i < this.listSupportedClaims.size()) {
            URI uriAttribute = (URI)this.listSupportedClaims.get(i);
            this.log.trace((Object)("Attribute: " + uriAttribute.toString()));
            Map mapAttributeClaim = (Map)this.mapAttributeClaims.get(uriAttribute.toString());
            if (mapAttributeClaim != null) {
                String strDisplayName = (String)mapAttributeClaim.get("DisplayName");
                this.log.trace((Object)("DisplayName: " + strDisplayName));
                strInformationCard = String.valueOf(strInformationCard) + "<SupportedClaimType Uri=\"" + uriAttribute.toString() + "\">" + "<DisplayTag>" + strDisplayName + "</DisplayTag>" + "<Description>" + strDisplayName + "</Description>" + "</SupportedClaimType>";
            }
            ++i;
        }
        strInformationCard = String.valueOf(strInformationCard) + "</SupportedClaimTypeList>" + (bRequireAppliesTo ? "<RequireAppliesTo/>" : "") + "</InformationCard>";
        this.log.trace((Object)"ProfileService::getManagedCard-8");
        Element elemInformationCard = new Element();
        this.log.trace((Object)"ProfileService::getManagedCard-9");
        elemInformationCard.set((Object)strInformationCard);
        this.log.trace((Object)"ProfileService::getManagedCard-10");
        IElement elemSignedInformationCard = this.xmlSecurityExtension.SignEnveloping((IElement)elemInformationCard, "IC01", (X509Certificate)this.mapGlobalSettings.get("IssuerCertificate"), (PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
        this.log.trace((Object)"ProfileService::getManagedCard-11");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String strSignedInformationCard = (String)elemSignedInformationCard.getAs((Class)clazz);
        this.log.trace((Object)"ProfileService::getManagedCard-12");
        return strSignedInformationCard.trim();
    }

    private DirContext getContext(URI uriProvider, String strPrincipal, String strCredential, String strTrustedStore, String strTrustedStorePassword) throws Exception {
        this.log.trace((Object)("getContext: " + strPrincipal + "/" + strCredential));
        Hashtable<String, String> htEnv = new Hashtable<String, String>();
        htEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        htEnv.put("java.naming.provider.url", uriProvider.toString());
        htEnv.put("java.naming.security.authentication", "simple");
        htEnv.put("java.naming.security.principal", strPrincipal);
        htEnv.put("java.naming.security.credentials", strCredential);
        htEnv.put("java.naming.ldap.attributes.binary", "GUID cardKey");
        return new InitialDirContext(htEnv);
    }

    public String createProfile(IConstants constants, String strUserIdentifier, String strUserPassword) throws Exception {
        DirContext context = this.getContext(this.uriLDAPProvider, this.strLDAPPrincipal, this.strLDAPCredential, this.strTrustedStore, this.strTrustedStorePassword);
        BasicAttributes attributesAdd = new BasicAttributes(true);
        BasicAttribute objectClass = new BasicAttribute("objectclass");
        int i = 0;
        while (i < this.listEntryObjectClass.size()) {
            String strObjectClass = (String)this.listEntryObjectClass.get(i);
            objectClass.add(strObjectClass);
            ++i;
        }
        attributesAdd.put(objectClass);
        BasicAttribute commonName = new BasicAttribute("cn");
        commonName.add(strUserIdentifier);
        attributesAdd.put(commonName);
        BasicAttribute surname = new BasicAttribute("sn");
        surname.add(" ");
        attributesAdd.put(surname);
        BasicAttribute userId = new BasicAttribute("uid");
        userId.add(strUserIdentifier);
        attributesAdd.put(userId);
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        userPassword.add(strUserPassword);
        attributesAdd.put(userPassword);
        context.createSubcontext(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, (Attributes)attributesAdd);
        return "Success";
    }

    public String getProfile(IConstants constants, String strUserIdentifier, String strUserPassword, IProfile profile) throws Exception {
        this.log.trace((Object)("org.eclipse.higgins.sts.server.profile.IProfileService#getProfile: " + strUserIdentifier));
        List listClaims = profile.getClaims();
        DirContext context = null;
        if (strUserIdentifier != null && strUserPassword != null) {
            context = this.getContext(this.uriLDAPProvider, String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, strUserPassword, this.strTrustedStore, this.strTrustedStorePassword);
        }
        if (context == null) {
            return "ERROR Invalid Username / Password";
        }
        Attributes attributesOut = null;
        if (context != null) {
            attributesOut = context.getAttributes(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix);
        }
        int i = 0;
        while (i < this.listSupportedClaims.size()) {
            URI uriAttribute = (URI)this.listSupportedClaims.get(i);
            this.log.trace((Object)("Attribute: " + uriAttribute.toString()));
            Map mapAttributeClaim = (Map)this.mapAttributeClaims.get(uriAttribute.toString());
            if (mapAttributeClaim != null) {
                String strDisplayName = (String)mapAttributeClaim.get("DisplayName");
                this.log.trace((Object)("DisplayName: " + strDisplayName));
                String strAttributeName = (String)mapAttributeClaim.get("AttributeName");
                this.log.trace((Object)("AttributeName: " + strAttributeName));
                if (strAttributeName != null) {
                    Attribute attribute;
                    String strShortName = (String)mapAttributeClaim.get("ClaimName");
                    this.log.trace((Object)("ShortName: " + strShortName));
                    ClaimType claimType = new ClaimType();
                    claimType.setName(uriAttribute);
                    claimType.setDisplayName(strDisplayName);
                    claimType.setShortName(strShortName);
                    Claim claim = new Claim();
                    claim.setType((IClaimType)claimType);
                    if (strAttributeName != null && attributesOut != null && (attribute = attributesOut.get(strAttributeName)) != null) {
                        NamingEnumeration<?> enumValues = attribute.getAll();
                        while (enumValues.hasMore()) {
                            String strValue = (String)enumValues.next();
                            this.log.trace((Object)("Value: " + strValue));
                            claim.addValue(strValue);
                        }
                    }
                    listClaims.add(claim);
                }
            } else {
                this.log.error((Object)"Attribute Not Found In AttributeClaimsMap");
            }
            ++i;
        }
        return "Success";
    }

    private void addStringAttribute(Attributes attributesModify, String strName, String strValue) {
        if (strValue != null && strValue.length() != 0) {
            this.log.trace((Object)("addStringAttribute: " + strName + " : " + strValue));
            BasicAttribute attribute = new BasicAttribute(strName);
            attribute.add(strValue);
            attributesModify.put(attribute);
        }
    }

    public String deleteProfile(IConstants constants, String strUserIdentifier, String strUserPassword) throws Exception {
        DirContext contextUser = this.getContext(this.uriLDAPProvider, String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, strUserPassword, this.strTrustedStore, this.strTrustedStorePassword);
        if (contextUser == null) {
            return "ERROR Invalid Username / Password";
        }
        contextUser.getAttributes(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix);
        DirContext context = this.getContext(this.uriLDAPProvider, this.strLDAPPrincipal, this.strLDAPCredential, this.strTrustedStore, this.strTrustedStorePassword);
        context.destroySubcontext(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix);
        return "Success";
    }

    public String modifyProfileSetCardKeyHash(IConstants constants, String strUserIdentifier, String strUserPassword, String strPPID, String strModulus, String strExponent) throws Exception {
        DirContext contextUser = this.getContext(this.uriLDAPProvider, String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, strUserPassword, this.strTrustedStore, this.strTrustedStorePassword);
        if (contextUser == null) {
            return "ERROR Invalid Username / Password";
        }
        contextUser.getAttributes(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix);
        DirContext context = this.getContext(this.uriLDAPProvider, this.strLDAPPrincipal, this.strLDAPCredential, this.strTrustedStore, this.strTrustedStorePassword);
        BasicAttributes attributesModify = new BasicAttributes(true);
        ByteArrayOutputStream cardKey = new ByteArrayOutputStream();
        cardKey.write(Base64.decodeBase64((byte[])strPPID.getBytes()));
        cardKey.write(Base64.decodeBase64((byte[])strModulus.getBytes()));
        cardKey.write(Base64.decodeBase64((byte[])strExponent.getBytes()));
        String strCardKeyHash = this.xmlSecurityExtension.SHA1Digest(cardKey.toByteArray());
        this.log.trace((Object)("CardKeyHash(in): " + strCardKeyHash));
        this.addStringAttribute(attributesModify, "cardKeyHash", strCardKeyHash);
        context.modifyAttributes(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, 1, (Attributes)attributesModify);
        return "Success";
    }

    public String modifyProfileSetX509SHA(IConstants constants, String strUserIdentifier, String strUserPassword, String strX509SHA) throws Exception {
        DirContext contextUser = this.getContext(this.uriLDAPProvider, String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, strUserPassword, this.strTrustedStore, this.strTrustedStorePassword);
        if (contextUser == null) {
            return "ERROR Invalid Username / Password";
        }
        DirContext context = this.getContext(this.uriLDAPProvider, this.strLDAPPrincipal, this.strLDAPCredential, this.strTrustedStore, this.strTrustedStorePassword);
        BasicAttributes attributesModify = new BasicAttributes(true);
        this.log.trace((Object)("X509 SHA(in): " + strX509SHA));
        this.addStringAttribute(attributesModify, "cardKeyHash", strX509SHA);
        context.modifyAttributes(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, 1, (Attributes)attributesModify);
        return "Success";
    }

    public String modifyProfile(IConstants constants, String strUserIdentifier, String strUserPassword, IProfile profile) throws Exception {
        this.log.trace((Object)"ProfileService::modifyProfile");
        DirContext contextUser = this.getContext(this.uriLDAPProvider, String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, strUserPassword, this.strTrustedStore, this.strTrustedStorePassword);
        if (contextUser == null) {
            return "ERROR Invalid Username / Password";
        }
        contextUser.getAttributes(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix);
        DirContext context = this.getContext(this.uriLDAPProvider, this.strLDAPPrincipal, this.strLDAPCredential, this.strTrustedStore, this.strTrustedStorePassword);
        BasicAttributes attributesModify = new BasicAttributes(true);
        List listClaims = profile.getClaims();
        int i = 0;
        while (i < listClaims.size()) {
            IClaim claim = (IClaim)listClaims.get(i);
            IClaimType claimType = claim.getType();
            String strShortName = claimType.getShortName();
            Iterator iterValues = claim.getValues();
            String strValue = null;
            if (iterValues.hasNext()) {
                strValue = (String)iterValues.next();
            }
            if (strValue != null) {
                String strAttributeName = (String)this.mapShortNameAttribute.get(strShortName);
                this.log.trace((Object)("ProfileService::modifyProfile: " + strAttributeName + "-" + strValue));
                this.addStringAttribute(attributesModify, strAttributeName, strValue);
            }
            ++i;
        }
        if (listClaims.size() != 0) {
            context.modifyAttributes(String.valueOf(this.strLDAPEntryPrefix) + strUserIdentifier + this.strLDAPEntrySuffix, 2, (Attributes)attributesModify);
        }
        return "Success";
    }

    public String decryptToken(IConstants constants, String strToken) throws Exception {
        this.log.trace((Object)"org.eclipse.higgins.sts.server.profile.IProfileService#decryptToken");
        if (strToken != null) {
            Element elemToken = new Element();
            elemToken.set((Object)strToken);
            this.log.trace((Object)"Decrypting Security Token");
            IElement elemDecryptedToken = this.xmlSecurityExtension.DecryptElement((IElement)elemToken, (PrivateKey)this.mapGlobalSettings.get("IssuerPrivateKey"));
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String strResult = (String)elemDecryptedToken.getAs((Class)clazz);
            this.log.trace((Object)("Decrypted Security Token: " + strResult));
            return strResult;
        }
        return "Success";
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }
}

