/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.token.identity;

import java.net.URI;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.common.AuthNSelfIssuedMaterials;
import org.eclipse.higgins.idas.common.AuthNX509CertificateMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.sts.api.IBinarySecurityToken;
import org.eclipse.higgins.sts.api.IClaim;
import org.eclipse.higgins.sts.api.IClaimType;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IDigitalIdentity;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IInformationCardReference;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISAMLToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.api.IUsernameToken;
import org.eclipse.higgins.sts.common.Claim;
import org.eclipse.higgins.sts.common.ClaimType;
import org.eclipse.higgins.sts.common.DigitalIdentity;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.server.token.handler.TokenHandler;
import org.eclipse.higgins.sts.utilities.CertificateHelper;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class DigitalIdentityHandler
extends TokenHandler {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$server$token$identity$DigitalIdentityHandler == null ? (class$org$eclipse$higgins$sts$server$token$identity$DigitalIdentityHandler = DigitalIdentityHandler.class$("org.eclipse.higgins.sts.server.token.identity.DigitalIdentityHandler")) : class$org$eclipse$higgins$sts$server$token$identity$DigitalIdentityHandler).getName());
    private URI uriSAMLAssertion = URI.create("urn:oasis:names:tc:SAML:1.0:assertion");
    private URI uriXMLSignature = URI.create("http://www.w3.org/2000/09/xmldsig#");
    private QName qnameAttribute = new QName(this.uriSAMLAssertion.toString(), "Attribute");
    private QName qnameAttributeName = new QName("AttributeName");
    private QName qnameAttributeValue = new QName(this.uriSAMLAssertion.toString(), "AttributeValue");
    private QName qnameSubject = new QName(this.uriSAMLAssertion.toString(), "Subject");
    private QName qnameSubjectConfirmation = new QName(this.uriSAMLAssertion.toString(), "SubjectConfirmation");
    private QName qnameKeyInfo = new QName(this.uriXMLSignature.toString(), "KeyInfo");
    private QName qnameKeyValue = new QName(this.uriXMLSignature.toString(), "KeyValue");
    private QName qnameRSAKeyValue = new QName(this.uriXMLSignature.toString(), "RSAKeyValue");
    private QName qnameModulus = new QName(this.uriXMLSignature.toString(), "Modulus");
    private QName qnameExponent = new QName(this.uriXMLSignature.toString(), "Exponent");
    private final QName qnameIdentityClaimType = new QName(null, "ClaimType");
    private final QName qnameIdentityClaimURI = new QName(null, "Uri");
    private final URI uriPPI = URI.create("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
    private boolean bConfigured = false;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$server$token$identity$DigitalIdentityHandler;
    static /* synthetic */ Class class$org$apache$axiom$om$OMElement;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$api$ISAMLToken;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$api$IUsernameToken;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$api$IBinarySecurityToken;

    protected DigitalIdentityHandler() {
        this.log.trace((Object)"DigitalIdentityHandler::DigitalIdentityHandler");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) {
        this.log.trace((Object)("DigitalIdentityHandler::configure: " + strComponentName));
        this.bConfigured = true;
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        this.log.trace((Object)("DigitalIdentityHandler::invoke: " + strComponentName));
        if (!this.bConfigured) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Issue handler not configured");
            response.setFault((IFault)fault);
            return;
        }
        DigitalIdentity digitalIdentity = new DigitalIdentity();
        String strTrustedStore = (String)mapGlobalSettings.get("LDAPTrustedStore");
        String strTrustedStorePassword = (String)mapGlobalSettings.get("LDAPTrustedStorePassword");
        if (null != strTrustedStore) {
            String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
            this.log.trace((Object)("ConfigurationBase: " + strConfigurationBase));
            System.setProperty("javax.net.ssl.trustStore", strConfigurationBase + "/" + strTrustedStore);
        }
        if (null != strTrustedStorePassword) {
            System.setProperty("javax.net.ssl.trustStorePassword", strTrustedStorePassword);
        }
        URI uriDefaultContextRef = (URI)mapComponentSettings.get("DefaultContextRef");
        this.log.trace((Object)("DefaultContextRef: " + uriDefaultContextRef.toString()));
        String strTrustedDelegator = (String)mapComponentSettings.get("TrustedDelegator");
        this.log.trace((Object)("TrustedDelegator: " + strTrustedDelegator));
        URI uriSubjectNameIdentifierAttribute = (URI)mapComponentSettings.get("SubjectNameIdentifierAttribute");
        this.log.trace((Object)("SubjectNameIdentifierAttribute: " + uriSubjectNameIdentifierAttribute.toString()));
        digitalIdentity.setSubjectNameIdentifierURI(uriSubjectNameIdentifierAttribute);
        boolean bSubjectNameIdentifierClaim = false;
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
        IdASRegistry IdAS = (IdASRegistry)mapGlobalSettings.get("IdentityAttributeService");
        AuthNNamePasswordMaterials credential = null;
        ISecurityInformation securityInformation = request.getSecurityInformation();
        IElement elemClaims = RST.getClaims();
        OMElement omClaims = null;
        if (null != elemClaims) {
            try {
                omClaims = (OMElement)elemClaims.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = DigitalIdentityHandler.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Unsupported contained object class.");
                response.setFault((IFault)fault);
                return;
            }
        }
        Iterator iterClaimTypes = null;
        ArrayList<URI> alIdentityClaims = new ArrayList<URI>();
        if (null != omClaims) {
            iterClaimTypes = omClaims.getChildrenWithName(this.qnameIdentityClaimType);
            while (iterClaimTypes.hasNext()) {
                OMElement elemClaimType = (OMElement)iterClaimTypes.next();
                String strAttributeURI = elemClaimType.getAttributeValue(this.qnameIdentityClaimURI);
                URI uriAttribute = URI.create(strAttributeURI);
                if (this.uriPPI.equals(uriAttribute)) {
                    digitalIdentity.setIncludePPIClaim(true);
                    continue;
                }
                if (null != uriSubjectNameIdentifierAttribute && uriSubjectNameIdentifierAttribute.equals(uriAttribute)) {
                    bSubjectNameIdentifierClaim = true;
                }
                this.log.trace((Object)("Adding Identity Attribute: " + uriAttribute.toString()));
                alIdentityClaims.add(uriAttribute);
            }
        }
        if (null != uriSubjectNameIdentifierAttribute && !bSubjectNameIdentifierClaim) {
            this.log.trace((Object)("Adding Identity Attribute: " + uriSubjectNameIdentifierAttribute.toString()));
            alIdentityClaims.add(uriSubjectNameIdentifierAttribute);
        }
        IEntity entity = null;
        URI uriContextRef = null;
        IInformationCardReference informationCardReference = RST.getInformationCardReference();
        if (null != informationCardReference) {
            uriContextRef = informationCardReference.getCardId();
        } else {
            if (null == uriDefaultContextRef) {
                uriContextRef = constants.getIssuerSelf();
            }
            uriContextRef = uriDefaultContextRef;
        }
        this.log.trace((Object)("ContextRef: " + uriContextRef.toString()));
        IContextId cid = null;
        List listFactories = null;
        try {
            int nParam;
            String strContextRef = uriContextRef.toString();
            if (strContextRef.startsWith("file://")) {
                int nQuery = strContextRef.indexOf("?id=");
                if (-1 != nQuery) {
                    strContextRef = strContextRef.substring(nQuery + 4);
                }
                strContextRef = "urn:" + strContextRef;
            }
            if (-1 != (nParam = strContextRef.indexOf("&"))) {
                strContextRef = strContextRef.substring(0, nParam);
            }
            cid = ContextIdFactory.fromConfiguration((String)strContextRef);
            listFactories = IdAS.getContextFactories(cid);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", e.getLocalizedMessage());
            response.setFault((IFault)fault);
            return;
        }
        this.log.trace((Object)"Iterating thru ContextFactories");
        for (int j = 0; j < listFactories.size(); ++j) {
            IContextFactory contextFactory = (IContextFactory)listFactories.get(j);
            try {
                Fault fault;
                this.log.trace((Object)("ContextFactory: " + contextFactory.getClass().getName()));
                this.log.trace((Object)("createContext: " + uriContextRef.toString()));
                IContext context = contextFactory.createContext(cid);
                if (null == securityInformation) {
                    this.log.trace((Object)"getSecurityInformation returned null");
                } else {
                    IBinarySecurityToken binaryToken;
                    IUsernameToken usernameToken;
                    ISAMLToken samlToken = (ISAMLToken)securityInformation.getFirst(class$org$eclipse$higgins$sts$api$ISAMLToken == null ? DigitalIdentityHandler.class$("org.eclipse.higgins.sts.api.ISAMLToken") : class$org$eclipse$higgins$sts$api$ISAMLToken);
                    String strModulus = null;
                    String strExponent = null;
                    String strPPID = null;
                    if (null != samlToken) {
                        IElement elemAttributeStatement = samlToken.getAttributeStatement();
                        OMElement omAttributeStatement = (OMElement)elemAttributeStatement.getAs(class$org$apache$axiom$om$OMElement == null ? DigitalIdentityHandler.class$("org.apache.axiom.om.OMElement") : class$org$apache$axiom$om$OMElement);
                        OMElement omSubject = omAttributeStatement.getFirstChildWithName(this.qnameSubject);
                        OMElement omSubjectConfirmation = omSubject.getFirstChildWithName(this.qnameSubjectConfirmation);
                        OMElement omKeyInfo = omSubjectConfirmation.getFirstChildWithName(this.qnameKeyInfo);
                        OMElement omKeyValue = omKeyInfo.getFirstChildWithName(this.qnameKeyValue);
                        OMElement omRSAKeyValue = omKeyValue.getFirstChildWithName(this.qnameRSAKeyValue);
                        OMElement omModulus = omRSAKeyValue.getFirstChildWithName(this.qnameModulus);
                        OMElement omExponent = omRSAKeyValue.getFirstChildWithName(this.qnameExponent);
                        strModulus = omModulus.getText();
                        strExponent = omExponent.getText();
                        Iterator iterAttributes = omAttributeStatement.getChildrenWithName(this.qnameAttribute);
                        while (iterAttributes.hasNext()) {
                            OMElement omAttribute = (OMElement)iterAttributes.next();
                            String strAttributeName = omAttribute.getAttributeValue(this.qnameAttributeName);
                            if (!strAttributeName.equals("privatepersonalidentifier")) continue;
                            OMElement omAttributeValue = omAttribute.getFirstChildWithName(this.qnameAttributeValue);
                            strPPID = omAttributeValue.getText();
                        }
                        this.log.trace((Object)"Creating PPID/Modulus/Exponent Credential");
                        try {
                            credential = new AuthNSelfIssuedMaterials(context, strPPID, strModulus, strExponent);
                        }
                        catch (Exception e) {
                            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                            Fault fault2 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", e.getLocalizedMessage());
                            response.setFault((IFault)fault2);
                            return;
                        }
                    }
                    if (null != (usernameToken = (IUsernameToken)securityInformation.getFirst(class$org$eclipse$higgins$sts$api$IUsernameToken == null ? DigitalIdentityHandler.class$("org.eclipse.higgins.sts.api.IUsernameToken") : class$org$eclipse$higgins$sts$api$IUsernameToken))) {
                        this.log.trace((Object)("Creating Username/Password Credential: " + usernameToken.getUsername() + "/XXXXXX"));
                        try {
                            credential = new AuthNNamePasswordMaterials(context, usernameToken.getUsername(), usernameToken.getPassword());
                        }
                        catch (Exception e) {
                            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                            Fault fault3 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", e.getLocalizedMessage());
                            response.setFault((IFault)fault3);
                            return;
                        }
                    }
                    if (null != (binaryToken = (IBinarySecurityToken)securityInformation.getFirst(class$org$eclipse$higgins$sts$api$IBinarySecurityToken == null ? DigitalIdentityHandler.class$("org.eclipse.higgins.sts.api.IBinarySecurityToken") : class$org$eclipse$higgins$sts$api$IBinarySecurityToken))) {
                        this.log.trace((Object)"Creating X.509 Credential");
                        try {
                            X509Certificate certificate = CertificateHelper.fromString((String)binaryToken.getEncodedValue());
                            MessageDigest mdSHA1 = MessageDigest.getInstance("SHA-1");
                            byte[] byteDigest = mdSHA1.digest(certificate.getEncoded());
                            credential = new AuthNX509CertificateMaterials(byteDigest);
                        }
                        catch (Exception e) {
                            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                            Fault fault4 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", e.getLocalizedMessage());
                            response.setFault((IFault)fault4);
                            return;
                        }
                    }
                }
                if (null == credential) {
                    fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", "Credential was not found");
                    response.setFault((IFault)fault);
                    return;
                }
                if (null != context) {
                    Fault fault5;
                    String strCUID = null;
                    this.log.trace((Object)"before IContext::open");
                    try {
                        strCUID = context.open(credential);
                    }
                    catch (Exception e) {
                        ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                        fault5 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", e.getLocalizedMessage());
                        response.setFault((IFault)fault5);
                        return;
                    }
                    catch (Throwable t) {
                        ExceptionHelper.Log((LogHelper)this.log, (Throwable)t);
                        fault5 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", t.getLocalizedMessage());
                        response.setFault((IFault)fault5);
                        return;
                    }
                    this.log.trace((Object)"after IContext::open");
                    this.log.trace((Object)"before IContext::getSubject");
                    entity = context.getEntity(strCUID);
                    this.log.trace((Object)"after IContext::getSubject");
                    this._displaySubjectInfo(entity);
                    if (null != entity) {
                        for (int i = 0; i < alIdentityClaims.size(); ++i) {
                            URI uriAttribute = (URI)alIdentityClaims.get(i);
                            this.log.trace((Object)("Adding Claim: " + uriAttribute.toString()));
                            ClaimType claimType = new ClaimType();
                            claimType.setName(uriAttribute);
                            Claim claim = new Claim();
                            claim.setType((IClaimType)claimType);
                            IAttribute attribute = entity.getAttribute(uriAttribute);
                            if (null != attribute) {
                                Iterator iterAttributeValues = attribute.getValues();
                                while (iterAttributeValues.hasNext()) {
                                    IValue attributeValue = (IValue)iterAttributeValues.next();
                                    if (attributeValue.isSimple()) {
                                        ISimpleValue value = (ISimpleValue)attributeValue;
                                        if (null == value) continue;
                                        String strValue = value.getLexical();
                                        this.log.trace((Object)("Adding Claim Value: " + strValue));
                                        claim.addValue(strValue);
                                        continue;
                                    }
                                    this.log.error((Object)"Unexpected complex value");
                                }
                                digitalIdentity.addClaim((IClaim)claim);
                                continue;
                            }
                            this.log.error((Object)"Could not find claim value");
                        }
                        this.log.trace((Object)"Calling setDigitalIdentity");
                        RST.setDigitalIdentity((IDigitalIdentity)digitalIdentity);
                        return;
                    }
                    this.log.trace((Object)"digitalSubject is null");
                    Fault fault6 = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", "digitalSubject is null");
                    response.setFault((IFault)fault6);
                    return;
                }
                this.log.trace((Object)"context is null");
                fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getFailedAuthenticationFaultCode(), "Authentication failed", "context is null");
                response.setFault((IFault)fault);
                continue;
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            }
        }
        this.log.trace((Object)"Done iterating thru ContextFactories");
        Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Node was not found");
        response.setFault((IFault)fault);
    }

    private void _displaySubjectInfo(IEntity subject) throws IdASException {
        Iterator attrIter = subject.getAttributes();
        System.out.println(subject.getEntityID());
        System.out.println(subject.getType());
        while (attrIter.hasNext()) {
            IAttribute attr = (IAttribute)attrIter.next();
            Iterator propValueIter = attr.getValues();
            System.out.println(attr.getType());
            while (propValueIter.hasNext()) {
                IValue propVal = (IValue)propValueIter.next();
                if (propVal.isSimple()) {
                    Object val = ((ISimpleValue)propVal).getData();
                    if (val instanceof String) {
                        System.out.println(val);
                        continue;
                    }
                    System.out.println("Unknown: " + val.toString());
                    continue;
                }
                System.out.println("Unknown Complex : ");
            }
        }
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

