/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.token.saml;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.higgins.sts.api.IAppliesTo;
import org.eclipse.higgins.sts.api.IClaim;
import org.eclipse.higgins.sts.api.IClaimType;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IDigitalIdentity;
import org.eclipse.higgins.sts.api.IDisplayToken;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ILifetime;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Claim;
import org.eclipse.higgins.sts.common.ClaimType;
import org.eclipse.higgins.sts.common.DisplayClaim;
import org.eclipse.higgins.sts.common.DisplayToken;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.common.RequestSecurityTokenResponse;
import org.eclipse.higgins.sts.server.token.handler.TokenHandler;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.DateHelper;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.UUIDHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;

public class TokenGeneratorHandler
extends TokenHandler {
    private final LogHelper log;
    QName qnameIdentityClaimType;
    QName qnameIdentityClaimURI;
    private boolean bConfigured;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected TokenGeneratorHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.server.token.saml.TokenGeneratorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.qnameIdentityClaimType = new QName(null, "ClaimType");
        this.qnameIdentityClaimURI = new QName(null, "Uri");
        this.bConfigured = false;
        this.log.trace((Object)"TokenGeneratorHandler::TokenGeneratorHandler");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        this.log.trace((Object)"TokenGeneratorHandler::initialize");
        this.bConfigured = true;
    }

    private void AddIdentityClaim(IConstants constants, IRequestSecurityToken RST, OMElement elemAttributeStatement, IDisplayToken dtDisplayToken, IClaim claim, Map mapAttributeClaim) {
        IClaimType claimType = claim.getType();
        URI uriClaimName = claimType.getName();
        String strClaimName = uriClaimName.toString();
        this.log.trace((Object)("Adding Identity Claim URI: " + strClaimName));
        Map mapClaim = (Map)mapAttributeClaim.get(strClaimName);
        String strAttributeName = (String)mapClaim.get("ClaimName");
        URI uriAttributeNamespace = (URI)mapClaim.get("AttributeNamespace");
        String strDisplayName = (String)mapClaim.get("DisplayName");
        this.log.trace((Object)("Adding Identity Claim Name: " + strAttributeName));
        if (strAttributeName == null) {
            this.log.error((Object)"Unsupported claim");
            return;
        }
        OMFactory omFactory = elemAttributeStatement.getOMFactory();
        OMNamespace omSAMLNamespace = omFactory.createOMNamespace(constants.getSAML10Namespace().toString(), "saml");
        omFactory.createOMNamespace(constants.getIdentityNamespace().toString(), "ic");
        OMElement elemAttribute = omFactory.createOMElement("Attribute", omSAMLNamespace, (OMContainer)elemAttributeStatement);
        DisplayClaim dcDisplayClaim = new DisplayClaim();
        dtDisplayToken.getDisplayClaimList().add(dcDisplayClaim);
        dcDisplayClaim.setType(claimType.getName());
        dcDisplayClaim.setDisplayTag(strDisplayName);
        elemAttribute.addAttribute("AttributeName", strAttributeName, null);
        elemAttribute.addAttribute("AttributeNamespace", uriAttributeNamespace.toString(), null);
        try {
            Iterator iterValue = claim.getValues();
            while (iterValue.hasNext()) {
                String strValue = (String)iterValue.next();
                this.log.trace((Object)("Adding Claim Value: " + strValue));
                dcDisplayClaim.setDisplayValue(strValue);
                OMElement elemAttributeValue = omFactory.createOMElement("AttributeValue", omSAMLNamespace, (OMContainer)elemAttribute);
                elemAttributeValue.setText(strValue);
            }
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
        }
    }

    private void AddPrivatePersonalIdentityClaim(IConstants constants, IRequestSecurityToken RST, OMElement elemAttributeStatement, IDisplayToken dtDisplayToken, IClaim claim, Map mapAttributeClaim) {
        IClaimType claimType = claim.getType();
        URI uriClaimName = claimType.getName();
        String strClaimName = uriClaimName.toString();
        this.log.trace((Object)("Adding Identity Claim URI: " + strClaimName));
        Map mapClaim = (Map)mapAttributeClaim.get(strClaimName);
        String strAttributeName = (String)mapClaim.get("ClaimName");
        URI uriAttributeNamespace = (URI)mapClaim.get("AttributeNamespace");
        String strDisplayName = (String)mapClaim.get("DisplayName");
        this.log.trace((Object)("Adding Identity Claim Name: " + strAttributeName));
        if (strAttributeName == null) {
            this.log.error((Object)"Unsupported claim");
            return;
        }
        OMFactory omFactory = elemAttributeStatement.getOMFactory();
        OMNamespace omSAMLNamespace = omFactory.createOMNamespace(constants.getSAML10Namespace().toString(), "saml");
        omFactory.createOMNamespace(constants.getIdentityNamespace().toString(), "ic");
        OMElement elemAttribute = omFactory.createOMElement("Attribute", omSAMLNamespace, (OMContainer)elemAttributeStatement);
        DisplayClaim dcDisplayClaim = new DisplayClaim();
        dtDisplayToken.getDisplayClaimList().add(dcDisplayClaim);
        dcDisplayClaim.setType(claimType.getName());
        dcDisplayClaim.setDisplayTag(strDisplayName);
        elemAttribute.addAttribute("AttributeName", strAttributeName, null);
        elemAttribute.addAttribute("AttributeNamespace", uriAttributeNamespace.toString(), null);
        try {
            IElement elemClientPseudonym = RST.getClientPseudonym();
            String strPPID = "BOGUS";
            if (elemClientPseudonym != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.apache.axiom.om.OMElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                OMElement omClientPseudonym = (OMElement)elemClientPseudonym.getAs((Class)clazz);
                Iterator iterPPID = omClientPseudonym.getChildElements();
                OMElement omPPID = (OMElement)iterPPID.next();
                strPPID = omPPID.getText();
            }
            this.log.trace((Object)("Adding Claim Value: " + strPPID));
            dcDisplayClaim.setDisplayValue(strPPID);
            OMElement elemAttributeValue = omFactory.createOMElement("AttributeValue", omSAMLNamespace, (OMContainer)elemAttribute);
            elemAttributeValue.setText(strPPID);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
        }
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        IClaim claim;
        URI uriSubjectNameIdentifierFormat;
        this.log.trace((Object)("TokenGeneratorHandler::invoke: " + strComponentName));
        if (!this.bConfigured) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Issue handler not configured");
            response.setFault((IFault)fault);
            return;
        }
        URI uriDefaultKeyType = (URI)mapComponentSettings.get("DefaultKeyType");
        this.log.trace((Object)("DefaultKeyType: " + uriDefaultKeyType.toString()));
        Boolean bIncludeBearerSubjectName = (Boolean)mapComponentSettings.get("IncludeBearerSubjectName");
        this.log.trace((Object)("IncludeBearerSubjectName: " + bIncludeBearerSubjectName.toString()));
        URI uriTokenIssuer = (URI)mapComponentSettings.get("TokenIssuer");
        this.log.trace((Object)("TokenIssuer: " + uriTokenIssuer.toString()));
        if (uriTokenIssuer == null) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "TokenIssuer not set.");
            response.setFault((IFault)fault);
            return;
        }
        URI uriSubjectNameIdentifier = (URI)mapComponentSettings.get("SubjectNameIdentifierAttribute");
        if (uriSubjectNameIdentifier != null) {
            this.log.trace((Object)("SubjectNameIdentifier: " + uriSubjectNameIdentifier.toString()));
        }
        if ((uriSubjectNameIdentifierFormat = (URI)mapComponentSettings.get("SubjectNameIdentifierFormat")) != null) {
            this.log.trace((Object)("SubjectNameIdentifierFormat: " + uriSubjectNameIdentifierFormat.toString()));
        }
        Boolean bEncryptToken = (Boolean)mapComponentSettings.get("EncryptToken");
        this.log.trace((Object)("EncryptToken: " + bEncryptToken.toString()));
        Map mapAttributeClaim = (Map)mapGlobalSettings.get("AttributeClaimMap");
        if (mapAttributeClaim == null) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "AttributeClaimMap not set.");
            response.setFault((IFault)fault);
            return;
        }
        IBase64Extension base64Extension = (IBase64Extension)mapGlobalSettings.get("Base64Extension");
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
        URI uriTokenType = RST.getTokenType();
        IAppliesTo appliesToRequest = RST.getAppliesTo();
        ILifetime ltLifetime = RST.getLifetime();
        URI uriKeyType = RST.getKeyType();
        if (uriKeyType == null) {
            uriKeyType = uriDefaultKeyType == null ? constants.getNoProofKeyKeyType() : uriDefaultKeyType;
        }
        String strSubjectNameIdentifier = null;
        boolean bBearerToken = uriKeyType.equals(constants.getNoProofKeyKeyType());
        IEndpointReference eprAppliesTo = null;
        URI uriAppliesTo = null;
        this.log.trace((Object)"Checking for AppliesTo");
        if (appliesToRequest != null) {
            this.log.trace((Object)"Found AppliesTo");
            eprAppliesTo = appliesToRequest.getEndpointReference();
            uriAppliesTo = eprAppliesTo.getAddress();
        }
        X509Certificate certificateIssuer = (X509Certificate)mapGlobalSettings.get("IssuerCertificate");
        PublicKey publicKeyIssuer = null;
        PrivateKey privateKeyIssuer = null;
        if (uriTokenIssuer.equals(constants.getIssuerSelf())) {
            KeyPair kpSelf = request.getSelfSigningKeyPair();
            this.log.trace((Object)("KeyPair Class: " + kpSelf.getClass().getName()));
            if (kpSelf == null) {
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Self Signing KeyPair not set.");
                response.setFault((IFault)fault);
                return;
            }
            publicKeyIssuer = kpSelf.getPublic();
            this.log.trace((Object)("PublicKey Class: " + publicKeyIssuer.getClass().getName()));
            if (publicKeyIssuer == null) {
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Self Signing PublicKey not set.");
                response.setFault((IFault)fault);
                return;
            }
            privateKeyIssuer = kpSelf.getPrivate();
            this.log.trace((Object)("PrivateKey Class: " + privateKeyIssuer.getClass().getName()));
            if (privateKeyIssuer == null) {
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Self Signing PrivateKey not set.");
                response.setFault((IFault)fault);
                return;
            }
        } else {
            publicKeyIssuer = certificateIssuer.getPublicKey();
            privateKeyIssuer = (PrivateKey)mapGlobalSettings.get("IssuerPrivateKey");
            if (certificateIssuer == null) {
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "IssuerCertificate not set.");
                response.setFault((IFault)fault);
                return;
            }
            if (privateKeyIssuer == null) {
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "IssuePrivateKey not set.");
                response.setFault((IFault)fault);
                return;
            }
        }
        URI uriAssertionID = UUIDHelper.getAsURI();
        Date dateNow = new Date();
        Date dateLater = new Date(dateNow.getTime() + 604800000L);
        String strNow = DateHelper.getIso8601Date((Date)dateNow);
        String strLater = DateHelper.getIso8601Date((Date)dateLater);
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        omFactory.createOMNamespace(constants.getIdentityNamespace().toString(), "ic");
        OMNamespace omWSTrustNamespace = omFactory.createOMNamespace(constants.getWSTrustNamespace().toString(), "wst");
        OMElement omRequestedAttachedReference = omFactory.createOMElement("RequestedAttachedReference", omWSTrustNamespace);
        OMElement omRequestedUnattachedReference = omFactory.createOMElement("RequestedUnattachedReference", omWSTrustNamespace);
        DisplayToken dtRequestedDisplayToken = new DisplayToken();
        OMNamespace omWSSNamespace = omFactory.createOMNamespace(constants.getWSSecurityNamespace().toString(), "wsse");
        OMElement omSecurityTokenReference1 = omFactory.createOMElement("SecurityTokenReference", omWSSNamespace, (OMContainer)omRequestedAttachedReference);
        OMElement omSecurityTokenReference2 = omFactory.createOMElement("SecurityTokenReference", omWSSNamespace, (OMContainer)omRequestedUnattachedReference);
        OMElement omKeyIdentifier1 = omFactory.createOMElement("KeyIdentifier", omWSSNamespace, (OMContainer)omSecurityTokenReference1);
        OMElement omKeyIdentifier2 = omFactory.createOMElement("KeyIdentifier", omWSSNamespace, (OMContainer)omSecurityTokenReference2);
        omKeyIdentifier1.addAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", null);
        omKeyIdentifier1.setText(uriAssertionID.toASCIIString());
        omKeyIdentifier2.addAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", null);
        omKeyIdentifier2.setText(uriAssertionID.toASCIIString());
        OMElement omRequestedSecurityToken = omFactory.createOMElement("RequestedSecurityToken", omWSTrustNamespace);
        OMNamespace omSAMLNamespace = omFactory.createOMNamespace(constants.getSAML10Namespace().toString(), "saml");
        OMElement omAssertion = omFactory.createOMElement("Assertion", omSAMLNamespace, (OMContainer)omRequestedSecurityToken);
        omAssertion.addAttribute("MajorVersion", "1", null);
        omAssertion.addAttribute("MinorVersion", "1", null);
        omAssertion.addAttribute("Issuer", uriTokenIssuer.toString(), null);
        omAssertion.addAttribute("AssertionID", uriAssertionID.toASCIIString(), null);
        omAssertion.addAttribute("IssueInstant", strNow.toString(), null);
        OMElement omConditions = omFactory.createOMElement("Conditions", omSAMLNamespace, (OMContainer)omAssertion);
        omConditions.addAttribute("NotBefore", strNow.toString(), null);
        omConditions.addAttribute("NotOnOrAfter", strLater.toString(), null);
        if (uriAppliesTo != null) {
            OMElement omAudienceRestrictionCondition = omFactory.createOMElement("AudienceRestrictionCondition", omSAMLNamespace, (OMContainer)omConditions);
            OMElement omAudience = omFactory.createOMElement("Audience", omSAMLNamespace, (OMContainer)omAudienceRestrictionCondition);
            omAudience.setText(uriAppliesTo.toString());
        }
        OMElement omAttributeStatement = omFactory.createOMElement("AttributeStatement", omSAMLNamespace, (OMContainer)omAssertion);
        OMElement omSubject = omFactory.createOMElement("Subject", omSAMLNamespace, (OMContainer)omAttributeStatement);
        IDigitalIdentity digitalIdentity = RST.getDigitalIdentity();
        if (digitalIdentity == null) {
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Node was not found");
            response.setFault((IFault)fault);
            return;
        }
        if (digitalIdentity.getIncludePPIClaim()) {
            ClaimType claimType = new ClaimType();
            claimType.setName(constants.getIdentityClaimPrivatePersonalIdentifier());
            Claim claim2 = new Claim();
            claim2.setType((IClaimType)claimType);
            this.AddPrivatePersonalIdentityClaim(constants, RST, omAttributeStatement, (IDisplayToken)dtRequestedDisplayToken, (IClaim)claim2, mapAttributeClaim);
        }
        List listClaims = digitalIdentity.getClaims();
        int i = 0;
        while (i < listClaims.size()) {
            claim = (IClaim)listClaims.get(i);
            this.AddIdentityClaim(constants, RST, omAttributeStatement, (IDisplayToken)dtRequestedDisplayToken, claim, mapAttributeClaim);
            ++i;
        }
        if (!bBearerToken || bIncludeBearerSubjectName.booleanValue()) {
            Iterator iterClaimValue;
            ClaimType claimType = new ClaimType();
            claimType.setName(uriSubjectNameIdentifier);
            claim = digitalIdentity.getClaim(uriSubjectNameIdentifier);
            if (claim != null && (iterClaimValue = claim.getValues()).hasNext()) {
                strSubjectNameIdentifier = (String)iterClaimValue.next();
            }
            if (strSubjectNameIdentifier == null) {
                this.log.error((Object)("Node does not contain Subject NameIdentifier Claim: " + uriSubjectNameIdentifier.toString()));
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Node does not contain Subject NameIdentifier Claim: " + uriSubjectNameIdentifier.toString());
                response.setFault((IFault)fault);
                return;
            }
            OMElement omNameIdentifier = omFactory.createOMElement("NameIdentifier", omSAMLNamespace, (OMContainer)omSubject);
            omNameIdentifier.addAttribute("Format", uriSubjectNameIdentifierFormat.toString(), null);
            omNameIdentifier.setText(strSubjectNameIdentifier);
        }
        OMElement omSubjectConfirmation = omFactory.createOMElement("SubjectConfirmation", omSAMLNamespace, (OMContainer)omSubject);
        OMElement omConfirmationMethod = omFactory.createOMElement("ConfirmationMethod", omSAMLNamespace, (OMContainer)omSubjectConfirmation);
        OMNamespace omDSNamespace = omFactory.createOMNamespace(constants.getXMLSignatureNamespace().toString(), "ds");
        IXMLSecurityExtension xmlSecurity = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
        if (bBearerToken) {
            omConfirmationMethod.setText(constants.getSAML10ConfirmationMethodBearer().toString());
        } else {
            try {
                omConfirmationMethod.setText(constants.getSAML10ConfirmationMethodHolderOfKey().toString());
                OMElement omKeyInfo = omFactory.createOMElement("KeyInfo", omDSNamespace, (OMContainer)omSubjectConfirmation);
                OMElement omKeyValue = omFactory.createOMElement("KeyValue", omDSNamespace, (OMContainer)omKeyInfo);
                OMElement omRSAKeyValue = omFactory.createOMElement("RSAKeyValue", omDSNamespace, (OMContainer)omKeyValue);
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKeyIssuer;
                BigInteger biModulus = rsaPublicKey.getModulus();
                String strModulus = base64Extension.encode(biModulus);
                strModulus = XMLHelper.stripNewLinesFromString((String)strModulus);
                BigInteger biExponent = rsaPublicKey.getPublicExponent();
                String strExponent = base64Extension.encode(biExponent);
                strExponent = XMLHelper.stripNewLinesFromString((String)strExponent);
                OMElement omModulus = omFactory.createOMElement("Modulus", omDSNamespace, (OMContainer)omRSAKeyValue);
                omModulus.setText(strModulus);
                OMElement omExponent = omFactory.createOMElement("Exponent", omDSNamespace, (OMContainer)omRSAKeyValue);
                omExponent.setText(strExponent);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "XML Signature operation failed.");
                response.setFault((IFault)fault);
                return;
            }
        }
        IElement elemSignedRequestedSecurityToken = null;
        try {
            Element elemRequestedSecurityToken = new Element();
            elemRequestedSecurityToken.set((Object)omRequestedSecurityToken);
            elemSignedRequestedSecurityToken = xmlSecurity.SignEnveloped("saml:Assertion", (IElement)elemRequestedSecurityToken, uriAssertionID.toASCIIString(), privateKeyIssuer, publicKeyIssuer, constants);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "XML Signature operation failed.");
            response.setFault((IFault)fault);
            return;
        }
        List listRSTR = response.getRequestSecurityTokenResponseCollection();
        if (listRSTR.size() == 0) {
            listRSTR.add(new RequestSecurityTokenResponse());
        }
        RequestSecurityTokenResponse RSTR = (RequestSecurityTokenResponse)listRSTR.get(0);
        try {
            RSTR.setTokenType(uriTokenType);
            RSTR.setLifetime(ltLifetime);
            RSTR.setRequestedSecurityToken(elemSignedRequestedSecurityToken);
            RSTR.setRequestedAttachedReference(XMLHelper.toElement((OMElement)omRequestedAttachedReference));
            RSTR.setRequestedUnattachedReference(XMLHelper.toElement((OMElement)omRequestedUnattachedReference));
            RSTR.setRequestedDisplayToken((IDisplayToken)dtRequestedDisplayToken);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Failed to set RequestSecurityToken elements.");
            response.setFault((IFault)fault);
            return;
        }
    }
}

