/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.token.self;

/**
 * Implements the IConfigurableComponentFactory that creates the IssueHandler implementation.
 * 
 * @author mikemci at us dot ibm dot com
 */
public class SelfIdentityHandlerFactory
	implements org.eclipse.higgins.configuration.api.IConfigurableComponentFactory
{
	/**
	 * Provides access to the singleton instance
	 * 
	 * @return the singleton instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getSingletonInstance()
	{
		return null;
	}
	
	/**
	 * Provides access to the new instance
	 * 
	 * @return the new instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getNewInstance()
	{
		return 	new org.eclipse.higgins.sts.server.token.self.SelfIdentityHandler();
	}
}
