/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.xmlsecurity.apache;

import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.CertificateHelper;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.eclipse.higgins.sts.xmlsecurity.apache.IDResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSecurityApacheExtension
implements IXMLSecurityExtension {
    private static final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$xmlsecurity$apache$XMLSecurityApacheExtension == null ? (class$org$eclipse$higgins$sts$xmlsecurity$apache$XMLSecurityApacheExtension = XMLSecurityApacheExtension.class$("org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtension")) : class$org$eclipse$higgins$sts$xmlsecurity$apache$XMLSecurityApacheExtension).getName());
    private String strSignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String strSignatureCanonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String strReferenceCanonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String strReferenceDigestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String strEncryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private String strEncryptionAlgorithmProvider = null;
    private String strEncryptionDigestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String strEncryptionKeyGeneratorAlgorithm = "AES";
    private String strEncryptionKeyGeneratorAlgorithmProvider = null;
    private int nEncryptionKeyGeneratorSize = 256;
    private String strEncryptionKeyWrapAlgorithm = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private String strEncryptionKeyWrapAlgorithmProvider = null;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$xmlsecurity$apache$XMLSecurityApacheExtension;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public IElement SignEnveloping(IElement elemObject, String strObjectId, X509Certificate x509Certificate, PrivateKey privateKey) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document docSignedManagedCard = documentBuilder.newDocument();
        XMLSignature xmlSignature = new XMLSignature(docSignedManagedCard, "", this.strSignatureAlgorithm, this.strSignatureCanonicalizationAlgorithm);
        docSignedManagedCard.appendChild(xmlSignature.getElement());
        ObjectContainer objectContainer = new ObjectContainer(docSignedManagedCard);
        Element domObject = (Element)elemObject.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLSecurityApacheExtension.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
        objectContainer.appendChild(docSignedManagedCard.importNode(domObject, true));
        objectContainer.setId(strObjectId);
        xmlSignature.appendObject(objectContainer);
        Transforms transforms = new Transforms(docSignedManagedCard);
        transforms.addTransform(this.strReferenceCanonicalizationAlgorithm);
        xmlSignature.addDocument("#" + strObjectId, transforms, this.strReferenceDigestAlgorithm);
        xmlSignature.addKeyInfo(x509Certificate);
        xmlSignature.sign((Key)privateKey);
        org.eclipse.higgins.sts.common.Element elemResult = new org.eclipse.higgins.sts.common.Element();
        elemResult.set((Object)XMLHelper.reparseElement((Element)xmlSignature.getElement()));
        return elemResult;
    }

    public String SHA1Digest(byte[] byteData) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.reset();
        byte[] byteDigest = md.digest(byteData);
        return org.apache.xml.security.utils.Base64.encode((byte[])byteDigest);
    }

    public IElement DecryptElement(IElement elemEncryptedData, PrivateKey privateKey) throws Exception {
        log.trace((Object)"DecryptElement");
        Element domEncryptedData = (Element)elemEncryptedData.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLSecurityApacheExtension.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
        NodeList nlEncryptedKey = domEncryptedData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        if (null == nlEncryptedKey) {
            log.trace((Object)"No EncryptedKey found (getElementsByTagName returned null)");
        } else if (0 == nlEncryptedKey.getLength()) {
            log.trace((Object)"No EncryptedKey found (0 == getLength())");
        } else {
            Document domDocument = domEncryptedData.getOwnerDocument();
            Element elemEncryptedKey = (Element)nlEncryptedKey.item(0);
            NodeList nlKeyEncryptionMethod = elemEncryptedKey.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
            String strKeyEncryptionMethod = null;
            if (null == nlKeyEncryptionMethod) {
                log.trace((Object)"No EncryptionMethod found");
                strKeyEncryptionMethod = this.strEncryptionKeyWrapAlgorithm;
            } else if (0 == nlKeyEncryptionMethod.getLength()) {
                log.trace((Object)"No EncryptionMethod found");
                strKeyEncryptionMethod = this.strEncryptionKeyWrapAlgorithm;
            } else {
                Element elemKeyEncryptionMethod = (Element)nlKeyEncryptionMethod.item(0);
                strKeyEncryptionMethod = elemKeyEncryptionMethod.getAttribute("Algorithm");
            }
            XMLCipher keyCipher = null;
            keyCipher = null == this.strEncryptionKeyWrapAlgorithmProvider ? XMLCipher.getInstance((String)strKeyEncryptionMethod) : XMLCipher.getProviderInstance((String)strKeyEncryptionMethod, (String)this.strEncryptionKeyWrapAlgorithmProvider);
            keyCipher.init(4, (Key)privateKey);
            EncryptedKey encryptedKey = keyCipher.loadEncryptedKey(domDocument, elemEncryptedKey);
            Key keySecret = keyCipher.decryptKey(encryptedKey, this.strEncryptionKeyWrapAlgorithm);
            SecretKey secretKey = (SecretKey)keySecret;
            byte[] encodedSecretKey = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(encodedSecretKey, this.strEncryptionKeyGeneratorAlgorithm);
            XMLCipher xmlCipher = null;
            xmlCipher = null == this.strEncryptionAlgorithmProvider ? XMLCipher.getInstance((String)this.strEncryptionAlgorithm) : XMLCipher.getProviderInstance((String)this.strEncryptionAlgorithm, (String)this.strEncryptionAlgorithmProvider);
            xmlCipher.init(2, (Key)secretKeySpec);
            Document domResultDocument = xmlCipher.doFinal(domDocument, domEncryptedData, false);
            org.eclipse.higgins.sts.common.Element elemResult = new org.eclipse.higgins.sts.common.Element();
            elemResult.set((Object)domResultDocument.getDocumentElement());
            return elemResult;
        }
        return null;
    }

    public IElement EncryptElement(String strTagNameOfElementToEncrypt, IElement elemParent, String strCertificate) throws Exception {
        Element domParent = (Element)elemParent.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLSecurityApacheExtension.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
        Document domDocument = domParent.getOwnerDocument();
        NodeList nlToEncrypts = domParent.getElementsByTagName(strTagNameOfElementToEncrypt);
        if (null == nlToEncrypts) {
            String strErrorMessage = "org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null";
            log.error((Object)"org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null");
            return null;
        }
        if (1 != nlToEncrypts.getLength()) {
            String strErrorMessage = "org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned " + nlToEncrypts.getLength() + " nodes";
            log.error((Object)strErrorMessage);
            return null;
        }
        Element domToEncrypt = (Element)nlToEncrypts.item(0);
        Element domTempParent = domDocument.createElement("Parent");
        Element domTempToEncrypt = (Element)domTempParent.appendChild(domToEncrypt.cloneNode(true));
        X509Certificate certificate = CertificateHelper.fromString((String)strCertificate);
        KeyGenerator keyGenerator = null;
        keyGenerator = null == this.strEncryptionKeyGeneratorAlgorithmProvider ? KeyGenerator.getInstance(this.strEncryptionKeyGeneratorAlgorithm) : KeyGenerator.getInstance(this.strEncryptionKeyGeneratorAlgorithm, this.strEncryptionKeyGeneratorAlgorithmProvider);
        keyGenerator.init(this.nEncryptionKeyGeneratorSize);
        SecretKey secretKey = keyGenerator.generateKey();
        PublicKey publicKeyRP = certificate.getPublicKey();
        XMLCipher keyCipher = null;
        keyCipher = null == this.strEncryptionKeyWrapAlgorithmProvider ? XMLCipher.getInstance((String)this.strEncryptionKeyWrapAlgorithm) : XMLCipher.getProviderInstance((String)this.strEncryptionKeyWrapAlgorithm, (String)this.strEncryptionKeyWrapAlgorithmProvider);
        keyCipher.init(3, (Key)publicKeyRP);
        KeyInfo keyInfoKey = new KeyInfo(domDocument);
        MessageDigest mdSha1 = MessageDigest.getInstance("SHA-1");
        byte[] byteThumbPrint = mdSha1.digest(certificate.getEncoded());
        Document domParentDocument = domParent.getOwnerDocument();
        Element domSTR = domParentDocument.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
        Element domKeyIdentifier = domParentDocument.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
        domKeyIdentifier.setAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
        domKeyIdentifier.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        String strThumbprint = org.apache.xml.security.utils.Base64.encode((byte[])byteThumbPrint);
        XMLHelper.setTextContent((Element)domKeyIdentifier, (String)strThumbprint);
        domSTR.appendChild(domKeyIdentifier);
        keyInfoKey.addUnknownElement(domSTR);
        EncryptedKey encryptedKey = keyCipher.encryptKey(domDocument, (Key)secretKey);
        encryptedKey.setKeyInfo(keyInfoKey);
        EncryptionMethod encryptionMethod = encryptedKey.getEncryptionMethod();
        Element elemDigestMethod = domDocument.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        elemDigestMethod.setAttribute("Algorithm", this.strEncryptionDigestAlgorithm);
        encryptionMethod.addEncryptionMethodInformation(elemDigestMethod);
        XMLCipher xmlCipher = null;
        xmlCipher = null == this.strEncryptionAlgorithmProvider ? XMLCipher.getInstance((String)this.strEncryptionAlgorithm) : XMLCipher.getProviderInstance((String)this.strEncryptionAlgorithm, (String)this.strEncryptionAlgorithmProvider);
        xmlCipher.init(1, (Key)secretKey);
        EncryptedData encryptedData = xmlCipher.getEncryptedData();
        KeyInfo keyInfoEncryption = new KeyInfo(domDocument);
        keyInfoEncryption.add(encryptedKey);
        encryptedData.setKeyInfo(keyInfoEncryption);
        xmlCipher.doFinal(domDocument, domTempToEncrypt, false);
        NodeList nlEncryptedData = domTempParent.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        if (1 != nlEncryptedData.getLength()) {
            throw new Exception("One EncryptedData Not Found!");
        }
        Element domEncryptedData = (Element)nlEncryptedData.item(0);
        XMLHelper.stripNewLinesFromElement((Element)((Element)nlEncryptedData.item(0)));
        domParent.replaceChild(domEncryptedData, domToEncrypt);
        org.eclipse.higgins.sts.common.Element elemResult = new org.eclipse.higgins.sts.common.Element();
        elemResult.set((Object)domParent);
        return elemResult;
    }

    public IElement SignDetached(String[] strElementIdsToSign, IElement elemParent, PrivateKey privateKey, PublicKey publicKey, String strIDOfToken, IConstants constants) throws Exception {
        if (0 == strElementIdsToSign.length) {
            throw new Exception("Sign Failed: Invalid Parameter: strElementIdsToSign is length 0");
        }
        if (null == elemParent) {
            throw new Exception("Sign Failed: Invalid Parameter: Parent is null");
        }
        if (null == privateKey) {
            throw new Exception("Sign Failed: Invalid Parameter: PrivateKey is null");
        }
        if (null == strIDOfToken) {
            throw new Exception("Sign Failed: Invalid Parameter: IDOfToken is null");
        }
        if (null == constants) {
            throw new Exception("Sign Failed: Invalid Parameter: Constants is null");
        }
        Constants.setSignatureSpecNSprefix((String)"ds");
        Element domParent = (Element)elemParent.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLSecurityApacheExtension.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
        Document domDocument = domParent.getOwnerDocument();
        Element domDocumentElement = domDocument.getDocumentElement();
        log.trace((Object)("SignDetached: " + XMLHelper.toString((Element)domDocumentElement)));
        XMLSignature signature = new XMLSignature(domDocument, "", this.strSignatureAlgorithm, this.strSignatureCanonicalizationAlgorithm);
        SignedInfo signedInfo = signature.getSignedInfo();
        IDResolver resolver = new IDResolver(domDocument);
        signedInfo.addResourceResolver((ResourceResolverSpi)resolver);
        for (int i = 0; i < strElementIdsToSign.length; ++i) {
            String strReferenceId = "#" + strElementIdsToSign[i];
            Transforms transforms = new Transforms(domDocument);
            transforms.addTransform(this.strReferenceCanonicalizationAlgorithm);
            signature.addDocument(strReferenceId, transforms);
        }
        KeyInfo keyInfo = signature.getKeyInfo();
        try {
            signature.sign((Key)privateKey);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
        Element domKeyInfo = keyInfo.getElement();
        Element domSTR = domDocument.createElementNS(constants.getWSSecurityNamespace().toString(), "SecurityTokenReference");
        Element domSTRReference = domDocument.createElementNS(constants.getWSSecurityNamespace().toString(), "Reference");
        domSTRReference.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        domSTRReference.setAttribute("URI", "#" + strIDOfToken);
        domSTR.appendChild(domSTRReference);
        domKeyInfo.appendChild(domSTR);
        Element domSignature = signature.getElement();
        org.eclipse.higgins.sts.common.Element elemResult = new org.eclipse.higgins.sts.common.Element();
        elemResult.set((Object)domSignature);
        return elemResult;
    }

    public IElement SignEnveloped(String strTagNameOfElementsToSign, IElement elemParent, String strReferenceIdentifier, PrivateKey privateKey, PublicKey publicKey, IConstants constants) throws Exception {
        if (null == strTagNameOfElementsToSign) {
            throw new Exception("Sign Failed: Invalid Parameter: TagNameOfElementsToSign is null");
        }
        if (null == elemParent) {
            throw new Exception("Sign Failed: Invalid Parameter: Parent is null");
        }
        if (null == strReferenceIdentifier) {
            throw new Exception("Sign Failed: Invalid Parameter: ReferenceIdentifier is null");
        }
        if (null == privateKey) {
            throw new Exception("Sign Failed: Invalid Parameter: PrivateKey is null");
        }
        if (null == publicKey) {
            throw new Exception("Sign Failed: Invalid Parameter: PublicKey is null");
        }
        if (null == constants) {
            throw new Exception("Sign Failed: Invalid Parameter: Constants is null");
        }
        Constants.setSignatureSpecNSprefix((String)"ds");
        Element domParent = (Element)elemParent.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLSecurityApacheExtension.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
        domParent = XMLHelper.reparseElement((Element)domParent);
        Document domDocument = domParent.getOwnerDocument();
        NodeList nlToSigns = domParent.getElementsByTagName(strTagNameOfElementsToSign);
        if (null == nlToSigns) {
            String strErrorMessage = "org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null";
            log.error((Object)"org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null");
            throw new Exception("Sign Failed: org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null");
        }
        if (1 != nlToSigns.getLength()) {
            String strErrorMessage = "org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned " + nlToSigns.getLength() + " nodes";
            log.error((Object)strErrorMessage);
            throw new Exception("Sign Failed: " + strErrorMessage);
        }
        Element domToSign = (Element)nlToSigns.item(0);
        XMLSignature signature = new XMLSignature(domDocument, "", this.strSignatureAlgorithm, this.strSignatureCanonicalizationAlgorithm);
        domToSign.appendChild(signature.getElement());
        SignedInfo signedInfo = signature.getSignedInfo();
        IDResolver resolver = new IDResolver(domDocument);
        signedInfo.addResourceResolver((ResourceResolverSpi)resolver);
        Transforms transforms = new Transforms(domDocument);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform(this.strReferenceCanonicalizationAlgorithm);
        signature.addDocument("#" + strReferenceIdentifier, transforms, this.strReferenceDigestAlgorithm);
        signature.addKeyInfo(publicKey);
        Element key = signature.getKeyInfo().getElement();
        Element elm = (Element)key.getFirstChild().getFirstChild().getFirstChild();
        String mod = elm.getTextContent();
        System.out.println(mod);
        byte[] bt = Base64.decode((String)mod);
        String newStr = Base64.encode((byte[])bt);
        System.out.println(newStr);
        elm.setTextContent(newStr);
        signature.sign((Key)privateKey);
        Element elemSignature = signature.getElement();
        NodeList nodeListSignatureValue = elemSignature.getElementsByTagNameNS(constants.getXMLSignatureNamespace().toString(), "SignatureValue");
        Element elemSignatureValue = (Element)nodeListSignatureValue.item(0);
        XMLHelper.stripWhiteSpaceFromElement((Element)elemSignatureValue);
        domParent = XMLHelper.reparseElement((Element)domParent);
        org.eclipse.higgins.sts.common.Element elemResult = new org.eclipse.higgins.sts.common.Element();
        elemResult.set((Object)domParent);
        return elemResult;
    }

    public boolean VerifyEnveloped(IElement elemSignedElement, IConstants constants) throws Exception {
        if (null == elemSignedElement) {
            throw new Exception("Verify Failed: Invalid Parameter: SignedElement is null");
        }
        Element domSignedElement = (Element)elemSignedElement.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLSecurityApacheExtension.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
        Document domParent = domSignedElement.getOwnerDocument();
        Element elemContext = XMLUtils.createDSctx(domParent, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Element elemSignature = (Element)XPathAPI.selectSingleNode((Node)domParent, (String)"//ds:Signature[1]", (Node)elemContext);
        XMLSignature signature = new XMLSignature(elemSignature, null);
        signature.addResourceResolver((ResourceResolverSpi)new IDResolver(domParent));
        KeyInfo keyInfo = signature.getKeyInfo();
        boolean bResult = false;
        if (keyInfo != null) {
            X509Certificate cert;
            if (keyInfo.containsX509Data()) {
                System.out.println("Found a X509Data element in the KeyInfo");
            }
            if ((cert = signature.getKeyInfo().getX509Certificate()) != null) {
                bResult = signature.checkSignatureValue(cert);
            } else {
                System.out.println("Did not find an X509Data element in the KeyInfo");
                PublicKey publicKey = keyInfo.getPublicKey();
                if (publicKey != null) {
                    bResult = signature.checkSignatureValue((Key)publicKey);
                } else {
                    System.out.println("Did not find a public key, so I can't check the signature");
                }
            }
        } else {
            System.out.println("Did not find a KeyInfo");
        }
        return bResult;
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) {
        System.err.println("XMLSecurityApacheExtension:configure");
        log.trace((Object)"XMLSecurityApacheExtension:configure");
        Init.init();
        if (null == mapComponentSettings) {
            return;
        }
        this.strSignatureAlgorithm = (String)mapComponentSettings.get("SignatureAlgorithm");
        if (null == this.strSignatureAlgorithm) {
            this.strSignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        log.trace((Object)("SignatureAlgorithm: " + this.strSignatureAlgorithm));
        this.strSignatureCanonicalizationAlgorithm = (String)mapComponentSettings.get("SignatureCanonicalizationAlgorithm");
        if (null == this.strSignatureCanonicalizationAlgorithm) {
            this.strSignatureCanonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        }
        log.trace((Object)("SignatureCanonicalizationAlgorithm: " + this.strSignatureCanonicalizationAlgorithm));
        this.strReferenceCanonicalizationAlgorithm = (String)mapComponentSettings.get("ReferenceCanonicalizationAlgorithm");
        if (null == this.strReferenceCanonicalizationAlgorithm) {
            this.strReferenceCanonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        }
        log.trace((Object)("ReferenceCanonicalizationAlgorithm: " + this.strReferenceCanonicalizationAlgorithm));
        this.strReferenceDigestAlgorithm = (String)mapComponentSettings.get("ReferenceDigestAlgorithm");
        if (null == this.strReferenceDigestAlgorithm) {
            this.strReferenceDigestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        log.trace((Object)("ReferenceDigestAlgorithm: " + this.strReferenceDigestAlgorithm));
        this.strEncryptionAlgorithm = (String)mapComponentSettings.get("EncryptionAlgorithm");
        if (null == this.strEncryptionAlgorithm) {
            this.strEncryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
        }
        log.trace((Object)("EncryptionAlgorithm: " + this.strEncryptionAlgorithm));
        this.strEncryptionAlgorithmProvider = (String)mapComponentSettings.get("EncryptionAlgorithmProvider");
        log.trace((Object)("EncryptionAlgorithmProvider: " + this.strEncryptionAlgorithmProvider));
        this.strEncryptionDigestAlgorithm = (String)mapComponentSettings.get("EncryptionDigestAlgorithm");
        if (null == this.strEncryptionDigestAlgorithm) {
            this.strEncryptionDigestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        log.trace((Object)("EncryptionDigestAlgorithm: " + this.strEncryptionDigestAlgorithm));
        this.strEncryptionKeyGeneratorAlgorithm = (String)mapComponentSettings.get("EncryptionKeyGeneratorAlgorithm");
        if (null == this.strEncryptionKeyGeneratorAlgorithm) {
            this.strEncryptionKeyGeneratorAlgorithm = "AES";
        }
        log.trace((Object)("EncryptionKeyGeneratorAlgorithm: " + this.strEncryptionKeyGeneratorAlgorithm));
        Integer intEncryptionKeyGeneratorSize = (Integer)mapComponentSettings.get("EncryptionKeyGeneratorSize");
        this.nEncryptionKeyGeneratorSize = null == intEncryptionKeyGeneratorSize ? 256 : intEncryptionKeyGeneratorSize;
        log.trace((Object)("EncryptionKeyGeneratorSize: " + this.nEncryptionKeyGeneratorSize));
        this.strEncryptionKeyGeneratorAlgorithmProvider = (String)mapComponentSettings.get("EncryptionKeyGeneratorAlgorithmProvider");
        log.trace((Object)("EncryptionKeyGeneratorAlgorithmProvider: " + this.strEncryptionKeyGeneratorAlgorithmProvider));
        this.strEncryptionKeyWrapAlgorithm = (String)mapComponentSettings.get("EncryptionKeyWrapAlgorithm");
        if (null == this.strEncryptionKeyWrapAlgorithm) {
            this.strEncryptionKeyWrapAlgorithm = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
        }
        log.trace((Object)("EncryptionKeyWrapAlgorithm: " + this.strEncryptionKeyWrapAlgorithm));
        this.strEncryptionKeyWrapAlgorithmProvider = (String)mapComponentSettings.get("EncryptionKeyWrapAlgorithmProvider");
        log.trace((Object)("EncryptionKeyWrapAlgorithmProvider: " + this.strEncryptionKeyWrapAlgorithmProvider));
    }

    public XMLSecurityApacheExtension() {
        System.err.println("XMLSecurityApacheExtension:XMLSecurityApacheExtension");
        log.trace((Object)"XMLSecurityApacheExtension:XMLSecurityApacheExtension");
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

