/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.auth.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * Represent Access Token entity.
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class AccessTokenEntity implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 *Represents token identifier.
	 */
	private String id;

	/**
	 *Represents issued date time.
	 */
	private Date issuedTime;

	/**
	 *Represents user identifier.
	 */
	private String userIdentifier;

	/**
	 * Represent client certificate. It may use for encrypting/decrypting transfered data.
	 */
	private byte[] clientCertificate;

	/**
	 * TODO It must be removed after updating UserProfileService API. Temporary field. Represents user name. It needs
	 * for compatibility with old UserProfileService API.
	 */
	private String userName;

	/**
	 * TODO It must be removed after updating UserProfileService API. Temporary field. Represents user password. It
	 * needs for compatibility with old UserProfileService API.
	 */
	private String userPassword;

	/**
	 * @return the clientCertificate
	 */
	public byte[] getClientCertificate() {
		return clientCertificate;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return the issuedTime
	 */
	public Date getIssuedTime() {
		return issuedTime;
	}

	/**
	 * @return the userIdentifier
	 */
	public String getUserIdentifier() {
		return userIdentifier;
	}

	/**
	 * @return the userName
	 */
	public String getUserName() {
		return userName;
	}

	/**
	 * @return the userPassword
	 */
	public String getUserPassword() {
		return userPassword;
	}

	/**
	 * @param clientCertificate
	 *            the clientCertificate to set
	 */
	public AccessTokenEntity setClientCertificate(byte[] clientCertificate) {
		this.clientCertificate = clientCertificate;
		return this;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public AccessTokenEntity setId(String id) {
		this.id = id;
		return this;
	}

	/**
	 * @param issuedTime
	 *            the issuedTime to set
	 */
	public AccessTokenEntity setIssuedTime(Date issuedTime) {
		this.issuedTime = issuedTime;
		return this;
	}

	/**
	 * @param userIdentifier
	 *            the userIdentifier to set
	 */
	public AccessTokenEntity setUserIdentifier(String userIdentifier) {
		this.userIdentifier = userIdentifier;
		return this;
	}

	/**
	 * @param userName
	 *            the userName to set
	 */
	public AccessTokenEntity setUserName(String userName) {
		this.userName = userName;
		return this;
	}

	/**
	 * @param userPassword
	 *            the userPassword to set
	 */
	public AccessTokenEntity setUserPassword(String userPassword) {
		this.userPassword = userPassword;
		return this;
	}

}
