/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.auth;

import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.auth.exceptions.AuthenticationException;

/**
 * IAuthenticateService represents API for supporting general authenticate operation.
 * 
 * @see http://wiki.eclipse.org/CardSync_Protocol#Authentication
 * 
 * @author Alexander Yuhimenko
 * 
 */
public interface IAuthenticateService {

	/**
	 *Represent access token ID header name.
	 */
	public static final String AUTHENTICATE_HEADER_NAME = "Authorization";

	public static final String AUTHENTICATE_HEADER_PREFIX = "HWS ";

	/**
	 * Returns early created AccessTokenEntity.
	 * 
	 * @param id
	 *            - access token id
	 * @return AccessTokenEntity
	 * @throws AuthenticationException
	 *             if AccessTokenEntity is invalid or not exists.
	 */
	AccessTokenEntity getAccessToken(String id) throws AuthenticationException;

	/**
	 * Add to store AccessTokenEntity.
	 * 
	 * @param accessTokenEntity
	 * @return AccessTokenEntity
	 * @throws AuthenticationException
	 */
	AccessTokenEntity persistAccessToken(AccessTokenEntity accessTokenEntity) throws AuthenticationException;

	/**
	 * Authenticate user and build AccessTokenEntity.
	 * 
	 * @param callbackHandler
	 *            the CallbackHandler that will be used to obtain user credentials.
	 * @return AccessTokenEntity
	 * @throws AuthenticationException
	 *             if couldn't authenticate user.
	 * @deprecated it was replaced by org.eclipse.higgins.user.login.LoginService
	 */
	// AccessTokenEntity authenticate(CallbackHandler callbackHandler) throws AuthenticationException;
	/**
	 * Delete AccessTokenEntity.
	 * 
	 * @param id
	 *            - access token id
	 * 
	 */
	void deleteAccessToken(String id);

}
