/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.bean;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.auth.PasswordCredential;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.sync.auth.IAuthenticateService;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.auth.exceptions.AuthenticationException;
import org.eclipse.higgins.sync.command.DeleteCardCommand;
import org.eclipse.higgins.sync.command.GetCardCommand;
import org.eclipse.higgins.sync.command.GetUserProfileCommand;
import org.eclipse.higgins.sync.command.IResourceCommand;
import org.eclipse.higgins.sync.command.PersistCardCommand;
import org.eclipse.higgins.sync.command.PersistUserProfileCommand;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RootRevisionEntity;
import org.eclipse.higgins.sync.meta.exceptions.ResourceMetaDataException;
import org.eclipse.higgins.sync.meta.utilities.ResourceUtil;
import org.eclipse.higgins.sync.to.AccessTokenTO;
import org.eclipse.higgins.sync.to.AuthCredentialTO;
import org.eclipse.higgins.sync.to.BaseTO;
import org.eclipse.higgins.sync.to.CardTO;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CmdExecStatusesTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.to.CommandsTO;
import org.eclipse.higgins.sync.to.CrdsFileTO;
import org.eclipse.higgins.sync.to.FileTO;
import org.eclipse.higgins.sync.to.RevisionTO;
import org.eclipse.higgins.sync.to.SelectorAuthCredentialTO;
import org.eclipse.higgins.sync.to.UserProfileTO;
import org.eclipse.higgins.sync.to.UsernamePasswordAuthCredentialTO;
import org.eclipse.higgins.sync.utilities.ConverterHelper;
import org.eclipse.higgins.sync.utilities.SecureUtil;
import org.eclipse.higgins.user.account.Account;
import org.eclipse.higgins.user.account.IUserAccountService;
import org.eclipse.higgins.user.account.UserAccountServiceFactory;
import org.eclipse.higgins.user.account.exception.UserAccountException;
import org.eclipse.higgins.user.account.exception.UserAlreadyExistsException;
import org.eclipse.higgins.user.account.utils.PasswordUtils;
import org.eclipse.higgins.user.login.LoginService;
import org.eclipse.higgins.user.login.UserAccount;
import org.eclipse.higgins.user.login.exception.ConfigurationException;
import org.eclipse.higgins.user.login.exception.LoginException;
import org.eclipse.higgins.user.profile.IUserProfileService;
import org.eclipse.higgins.user.profile.UserProfileServiceFactory;
import org.eclipse.higgins.user.profile.entity.SelectorClient;
import org.eclipse.higgins.user.profile.entity.UserProfile;
import org.eclipse.higgins.user.profile.exception.UserProfileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardSyncFacadeBean {
    private static Log LOG = LogFactory.getLog(CardSyncFacadeBean.class);
    private static Integer maxIdleTime = new Integer(1800);
    private static Integer maxLiveTime = new Integer(86400);
    public static final ThreadLocal<IUserProfileService> userProfileService = new ThreadLocal<IUserProfileService>(){

        @Override
        protected synchronized IUserProfileService initialValue() {
            IUserProfileService userProfileServiceInstance = null;
            try {
                ConfigurationHandler configurationHandler = new ConfigurationHandler();
                configurationHandler.setConfigurationBase((String)SecureUtil.getContext().lookup("HigginsConfigurationBase"));
                configurationHandler.setFileName((String)SecureUtil.getContext().lookup("HigginsConfigurationFile"));
                if (!configurationHandler.configure(null)) {
                    throw new ConfigurationException("Could not configure");
                }
                userProfileServiceInstance = UserProfileServiceFactory.getService((Map)configurationHandler.getSettings());
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            return userProfileServiceInstance;
        }
    };
    public static final ThreadLocal<LoginService> loginService = new ThreadLocal<LoginService>(){

        @Override
        protected synchronized LoginService initialValue() {
            LoginService loginServiceInstance = null;
            try {
                ConfigurationHandler configurationHandler = new ConfigurationHandler();
                configurationHandler.setConfigurationBase((String)SecureUtil.getContext().lookup("HigginsConfigurationBase"));
                configurationHandler.setFileName((String)SecureUtil.getContext().lookup("HigginsConfigurationFile"));
                if (!configurationHandler.configure(null)) {
                    throw new ConfigurationException("Could not configure");
                }
                loginServiceInstance = LoginService.getInstance((Map)configurationHandler.getSettings());
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            return loginServiceInstance;
        }
    };
    public static final ThreadLocal<IResourceMetaDataService> metaDataService = new ThreadLocal<IResourceMetaDataService>(){

        @Override
        protected synchronized IResourceMetaDataService initialValue() {
            IResourceMetaDataService metaDataServiceInstance = null;
            try {
                metaDataServiceInstance = (IResourceMetaDataService)SecureUtil.getContext().lookup("cardsync/ResourceMetaDataService");
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            return metaDataServiceInstance;
        }
    };
    public static final ThreadLocal<IUserAccountService> userAccountService = new ThreadLocal<IUserAccountService>(){

        @Override
        protected synchronized IUserAccountService initialValue() {
            IUserAccountService userAccountServiceInstance = null;
            try {
                ConfigurationHandler configurationHandler = new ConfigurationHandler();
                configurationHandler.setConfigurationBase((String)SecureUtil.getContext().lookup("HigginsConfigurationBase"));
                configurationHandler.setFileName((String)SecureUtil.getContext().lookup("HigginsConfigurationFile"));
                if (!configurationHandler.configure(null)) {
                    throw new ConfigurationException("Could not configure");
                }
                userAccountServiceInstance = UserAccountServiceFactory.getService((Map)configurationHandler.getSettings());
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            return userAccountServiceInstance;
        }
    };
    public static final ThreadLocal<IAuthenticateService> authenticateService = new ThreadLocal<IAuthenticateService>(){

        @Override
        protected synchronized IAuthenticateService initialValue() {
            IAuthenticateService authServiceInstance = null;
            try {
                authServiceInstance = (IAuthenticateService)SecureUtil.getContext().lookup("cardsync/AuthenticateService");
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            return authServiceInstance;
        }
    };
    public static final ThreadLocal<Map<String, IResourceCommand>> commandMap = new ThreadLocal<Map<String, IResourceCommand>>(){

        @Override
        protected synchronized Map<String, IResourceCommand> initialValue() {
            HashMap<String, IResourceCommand> cmdMap = new HashMap<String, IResourceCommand>();
            try {
                cmdMap.put("Getorg.eclipse.higgins.sync.to.CardTO", new GetCardCommand(metaDataService.get()));
                cmdMap.put("Persistorg.eclipse.higgins.sync.to.CardTO", new PersistCardCommand(metaDataService.get()));
                cmdMap.put("Deleteorg.eclipse.higgins.sync.to.CardTO", new DeleteCardCommand(metaDataService.get()));
                cmdMap.put("Getorg.eclipse.higgins.sync.to.UserProfileTO", new GetUserProfileCommand(metaDataService.get(), userProfileService.get(), userAccountService.get()));
                cmdMap.put("Persistorg.eclipse.higgins.sync.to.UserProfileTO", new PersistUserProfileCommand(metaDataService.get(), userProfileService.get(), userAccountService.get()));
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            return cmdMap;
        }
    };

    public UserProfileTO createUserProfile(UserProfileTO userProfileTO) throws ResourceMetaDataException, UserProfileException, NoSuchAlgorithmException, UnsupportedEncodingException, UserAccountException {
        if (!userAccountService.get().existsAccount(userProfileTO.getLoginName())) {
            Account account = userAccountService.get().createAccount(null, new Account().setCreated(new Date()).setLogin(userProfileTO.getLoginName()).setPasswordHash(PasswordUtils.getPasswordHash((String)((UsernamePasswordAuthCredentialTO)userProfileTO.getAuthCredentialTO()).getPassword())));
            UserProfile userProfile = new UserProfile();
            ConverterHelper.userProfileTO2UserProfile(userProfileTO, userProfile);
            userProfile.setUserIdentifier((Serializable)((Object)account.getId()));
            UserProfile up = userProfileService.get().addUserProfile((Serializable)((Object)account.getId()), userProfile);
            ResourceUtil resourceUtil = new ResourceUtil();
            RootRevisionEntity rootRevisionEntity = resourceUtil.persistRoorRevision(metaDataService.get(), up.getUserIdentifier());
            ResourceRevisionEntity revisionEntity = resourceUtil.persistResourceRevision(metaDataService.get(), up.getUserIdentifier(), "org.eclipse.higgins.sync.to.UserProfileTO", (String)((Object)up.getUserIdentifier()), rootRevisionEntity.getId());
            return ConverterHelper.userProfile2UserProfileTO(up, account, (RevisionEntity)revisionEntity);
        }
        throw new UserAlreadyExistsException();
    }

    public void deleteAccessToken(String id) {
        authenticateService.get().deleteAccessToken(id);
    }

    public UserAccount authenticate(AuthCredentialTO authCredentialTO) throws ConfigurationException, LoginException, AuthenticationException, UserProfileException {
        if (authCredentialTO instanceof SelectorAuthCredentialTO) {
            SelectorAuthCredentialTO auth = (SelectorAuthCredentialTO)authCredentialTO;
            UserAccount account = loginService.get().login(SecureUtil.getCallbackHandler(auth.getUsername(), auth.getPassword()));
            List selectorClients = userProfileService.get().getSelectorClients(account.getUserId());
            SelectorClient selector = new SelectorClient().setSerialNumber(auth.getSelectorSerialNumber());
            if (null != selectorClients && selectorClients.contains(selector)) {
                if ("Active".equals((selector = (SelectorClient)selectorClients.get(selectorClients.indexOf(selector))).getState())) {
                    return account;
                }
                throw new AuthenticationException("Selector was locked.");
            }
            throw new AuthenticationException("Couldn't find selector client.");
        }
        if (authCredentialTO instanceof UsernamePasswordAuthCredentialTO) {
            UsernamePasswordAuthCredentialTO auth = (UsernamePasswordAuthCredentialTO)authCredentialTO;
            return loginService.get().login(SecureUtil.getCallbackHandler(auth.getUsername(), auth.getPassword()));
        }
        throw new AuthenticationException("Unsupported  AuthCredentialTO type");
    }

    public AccessTokenTO createAccessToken(AuthCredentialTO authCredentialTO) throws AuthenticationException, ConfigurationException, LoginException, UserProfileException {
        UserAccount account = this.authenticate(authCredentialTO);
        AccessTokenEntity accessToken = authenticateService.get().persistAccessToken(new AccessTokenEntity().setUserIdentifier(account.getUserId().toString()));
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        accessTokenTO.setId(accessToken.getId());
        accessTokenTO.setIssuedTime(accessToken.getIssuedTime());
        accessTokenTO.setMaxIdleTime(maxIdleTime);
        accessTokenTO.setMaxLiveTime(maxLiveTime);
        RootRevisionEntity rootRevisionEntity = new RootRevisionEntity();
        rootRevisionEntity.setResourceType("RootResource").setResourceId(accessToken.getUserIdentifier()).setUserId(accessToken.getUserIdentifier());
        try {
            if (null == metaDataService.get().findResourceRevisionEntity((RevisionEntity)rootRevisionEntity)) {
                metaDataService.get().persistResourceRevisionEntity((RevisionEntity)rootRevisionEntity);
            }
        }
        catch (ResourceMetaDataException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return accessTokenTO;
    }

    public AccessTokenEntity getAccessToken(String accessTokenId) throws AuthenticationException {
        if (null != accessTokenId && accessTokenId.trim().length() > 0 && accessTokenId.trim().startsWith("HWS ")) {
            accessTokenId = accessTokenId.trim().substring("HWS ".length());
        }
        return authenticateService.get().getAccessToken(accessTokenId);
    }

    public RevisionTO getRootRevision(AccessTokenEntity accessToken, List<String> resourceTypeList) throws AuthenticationException, ResourceMetaDataException {
        RevisionEntity res = null;
        if (null == resourceTypeList || resourceTypeList.size() == 0) {
            resourceTypeList = new ArrayList<String>(){
                {
                    this.add("RootResource");
                }
            };
        }
        for (String resourceType : resourceTypeList) {
            RevisionEntity revisionEntity = metaDataService.get().findMaxRevisionEntity(new RevisionEntity().setUserId(accessToken.getUserIdentifier()).setResourceType(resourceType));
            if (null == revisionEntity || null != res && res.getNumber() >= revisionEntity.getNumber()) continue;
            res = revisionEntity;
        }
        return ConverterHelper.revisionEntity2RevisionTO(res);
    }

    public UserProfileTO getUserProfile(AccessTokenEntity accessTokenEntity) throws ResourceMetaDataException, UserProfileException, UserAccountException {
        UserProfile userProfile = userProfileService.get().getUserProfile((Serializable)((Object)accessTokenEntity.getUserIdentifier()));
        RevisionEntity revisionEntity = new RevisionEntity().setResourceType("org.eclipse.higgins.sync.to.UserProfileTO").setResourceId(accessTokenEntity.getUserIdentifier()).setUserId(accessTokenEntity.getUserIdentifier());
        revisionEntity = metaDataService.get().findResourceRevisionEntity(revisionEntity);
        return ConverterHelper.userProfile2UserProfileTO(userProfile, userAccountService.get().getAccount((Serializable)((Object)accessTokenEntity.getUserIdentifier())), revisionEntity);
    }

    public void deleteUserProfile(AccessTokenEntity accessTokenEntity) throws ResourceMetaDataException, UserProfileException, UserAccountException {
        Iterator iter = ICardRegistry.getInstance().getICardProviders();
        while (iter.hasNext()) {
            ICardProvider provider = (ICardProvider)iter.next();
            try {
                CallbackHandler callbackHandler = SecureUtil.getCallbackHandler(accessTokenEntity);
                Iterator icards = provider.getICards(callbackHandler);
                while (icards.hasNext()) {
                    try {
                        this.deleteCard(accessTokenEntity, ((IInformationCard)icards.next()).getCUID().toString());
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        userProfileService.get().deleteUserProfile((Serializable)((Object)accessTokenEntity.getUserIdentifier()));
        userAccountService.get().deleteAccount((Serializable)((Object)accessTokenEntity.getUserIdentifier()));
        RevisionEntity revisionEntity = new RevisionEntity().setResourceType(UserProfileTO.class.getCanonicalName()).setResourceId(accessTokenEntity.getUserIdentifier()).setUserId(accessTokenEntity.getUserIdentifier());
        metaDataService.get().deleteResourceRevisionEntity(revisionEntity);
        revisionEntity = new RevisionEntity().setResourceType("RootResource").setResourceId(accessTokenEntity.getUserIdentifier()).setUserId(accessTokenEntity.getUserIdentifier());
        metaDataService.get().deleteResourceRevisionEntity(revisionEntity);
    }

    public UserProfileTO updateUserProfile(AccessTokenEntity accessTokenEntity, UserProfileTO userProfileTO) throws ResourceMetaDataException, UserProfileException, UserAccountException {
        UserProfile userProfile = new UserProfile().setUserIdentifier((Serializable)((Object)accessTokenEntity.getUserIdentifier()));
        ConverterHelper.userProfileTO2UserProfile(userProfileTO, userProfile);
        userProfileService.get().modifyUserProfile((Serializable)((Object)accessTokenEntity.getUserIdentifier()), userProfile);
        RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision(metaDataService.get(), accessTokenEntity.getUserIdentifier());
        ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
        revisionEntity.setResourceType(UserProfileTO.class.getCanonicalName()).setResourceId(accessTokenEntity.getUserIdentifier()).setUserId(accessTokenEntity.getUserIdentifier()).setParentId(rootRevisionEntity.getId());
        metaDataService.get().persistResourceRevisionEntity((RevisionEntity)revisionEntity);
        return ConverterHelper.userProfile2UserProfileTO(userProfile, userAccountService.get().getAccount((Serializable)((Object)accessTokenEntity.getUserIdentifier())), (RevisionEntity)revisionEntity);
    }

    public List<CardTO> getCards(AccessTokenEntity accessTokenEntity) throws ResourceMetaDataException, CardException {
        ArrayList<CardTO> cards = new ArrayList<CardTO>();
        Iterator iter = ICardRegistry.getInstance().getICardProviders();
        while (iter.hasNext()) {
            ICardProvider provider = (ICardProvider)iter.next();
            try {
                CallbackHandler callbackHandler = SecureUtil.getCallbackHandler(accessTokenEntity);
                Iterator icards = provider.getICards(callbackHandler);
                while (icards.hasNext()) {
                    CardTO cardTO = ConverterHelper.card2CardTO((IInformationCard)icards.next());
                    try {
                        RevisionEntity revisionEntity = new RevisionEntity().setResourceType("org.eclipse.higgins.sync.to.CardTO").setResourceId(cardTO.getId()).setUserId(accessTokenEntity.getUserIdentifier());
                        cardTO.setRevision(ConverterHelper.revisionEntity2RevisionTO(metaDataService.get().findResourceRevisionEntity(revisionEntity)));
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                    cards.add(cardTO);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return cards;
    }

    public CardTO getCard(AccessTokenEntity accessTokenEntity, String id) throws ResourceMetaDataException, CardException {
        IResourceCommand cmd = commandMap.get().get("Getorg.eclipse.higgins.sync.to.CardTO");
        if (null == cmd) {
            throw new CardException("Unsupported command : Getorg.eclipse.higgins.sync.to.CardTO");
        }
        CmdExecStatusTO execCmd = cmd.execCmd(accessTokenEntity, new CommandTO().setName("Get").setResourceId(id).setResourceType("org.eclipse.higgins.sync.to.CardTO"));
        if ("0".equals(execCmd.getStatusCode())) {
            return (CardTO)execCmd.getResource();
        }
        throw new NullPointerException("Couldn't get card due to :" + execCmd.getStatusMessage());
    }

    public CardTO persistCard(AccessTokenEntity accessTokenEntity, CardTO cardTO) throws ResourceMetaDataException, CardException {
        IResourceCommand cmd = commandMap.get().get("Persistorg.eclipse.higgins.sync.to.CardTO");
        if (null == cmd) {
            throw new CardException("Unsupported command : Persistorg.eclipse.higgins.sync.to.CardTO");
        }
        CmdExecStatusTO execCmd = cmd.execCmd(accessTokenEntity, new CommandTO().setName("Persist").setResource(cardTO).setResourceType("org.eclipse.higgins.sync.to.CardTO"));
        if ("0".equals(execCmd.getStatusCode())) {
            return (CardTO)execCmd.getResource();
        }
        throw new NullPointerException("Couldn't get card due to :" + execCmd.getStatusMessage());
    }

    public void deleteCard(AccessTokenEntity accessTokenEntity, String id) {
        try {
            IResourceCommand cmd = commandMap.get().get("Deleteorg.eclipse.higgins.sync.to.CardTO");
            if (null != cmd) {
                CmdExecStatusTO execCmd = cmd.execCmd(accessTokenEntity, new CommandTO().setName("Delete").setResourceId(id).setResourceType("org.eclipse.higgins.sync.to.CardTO"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public List<CardTO> importFromCrd(AccessTokenEntity accessTokenEntity, FileTO fileTO) throws CardException, ResourceMetaDataException {
        ArrayList<CardTO> cards = new ArrayList<CardTO>();
        PasswordCredential credential = null;
        if (fileTO instanceof CrdsFileTO) {
            credential = new PasswordCredential();
            credential.setPassword(((CrdsFileTO)fileTO).getPasswordPhrase());
        }
        RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision(metaDataService.get(), accessTokenEntity.getUserIdentifier());
        ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
        Iterator icards = ICardRegistry.getInstance().importICards(SecureUtil.getCallbackHandler(accessTokenEntity), (InputStream)new ByteArrayInputStream(fileTO.getFileData()), null, (ICredential)credential);
        while (icards.hasNext()) {
            CardTO cardTO = ConverterHelper.card2CardTO((IInformationCard)icards.next());
            revisionEntity.setResourceType("org.eclipse.higgins.sync.to.CardTO").setResourceId(cardTO.getId()).setUserId(accessTokenEntity.getUserIdentifier()).setParentId(rootRevisionEntity.getId());
            metaDataService.get().persistResourceRevisionEntity((RevisionEntity)revisionEntity);
            cardTO.setRevision(ConverterHelper.revisionEntity2RevisionTO((RevisionEntity)revisionEntity));
            cards.add(cardTO);
        }
        return cards;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandsTO getCommandLog(AccessTokenEntity accessTokenEntity, RevisionTO clientRootRevisionTO, List<String> resourceTypeList) throws ResourceMetaDataException, AuthenticationException {
        ArrayList<CommandTO> res = new ArrayList<CommandTO>();
        if (null == resourceTypeList || resourceTypeList.size() == 0) {
            resourceTypeList = new ArrayList<String>(){
                {
                    this.add(null);
                }
            };
        }
        for (String resourceType : resourceTypeList) {
            List revList = metaDataService.get().getResourceRevisionEntityList(ConverterHelper.revisionTO2revisionEntity(clientRootRevisionTO).setUserId(accessTokenEntity.getUserIdentifier()), resourceType);
            int i = 0;
            for (RevisionEntity revisionEntity : revList) {
                try {
                    BaseTO resource = null;
                    if (!"Delete".equals(revisionEntity.getCommandName())) {
                        IResourceCommand cmd = commandMap.get().get("Get" + revisionEntity.getResourceType());
                        if (null == cmd) throw new NullPointerException("Unsupported command : Get" + revisionEntity.getResourceType());
                        CmdExecStatusTO execCmd = cmd.execCmd(accessTokenEntity, new CommandTO().setName("Get").setResourceId(revisionEntity.getResourceId()).setResourceType(revisionEntity.getResourceType()));
                        if (!"0".equals(execCmd.getStatusCode())) throw new NullPointerException("Couldn't get resource due to :" + execCmd.getStatusMessage());
                        resource = execCmd.getResource();
                    }
                    res.add(new CommandTO().setName(revisionEntity.getCommandName()).setResourceId(revisionEntity.getResourceId()).setResourceType(revisionEntity.getResourceType()).setId("" + i++).setResource(resource));
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
        }
        CommandsTO commandTOs = new CommandsTO().setCommandTO(res.toArray(new CommandTO[res.size()]));
        commandTOs.setRevision(this.getRootRevision(accessTokenEntity, (List<String>)resourceTypeList));
        return commandTOs;
    }

    public CmdExecStatusesTO execCommands(AccessTokenEntity accessTokenEntity, CommandsTO commandsTO, List<String> resourceTypeList) throws ResourceMetaDataException, AuthenticationException {
        ArrayList<CmdExecStatusTO> res = new ArrayList<CmdExecStatusTO>();
        CommandTO[] commandTOs = commandsTO.getCommandTO();
        for (int i = 0; i < commandTOs.length; ++i) {
            try {
                IResourceCommand cmd = commandMap.get().get(commandTOs[i].getName() + commandTOs[i].getResourceType());
                if (null == cmd) continue;
                res.add(cmd.execCmd(accessTokenEntity, commandTOs[i]));
                continue;
            }
            catch (Exception e) {
                res.add(new CmdExecStatusTO().setId(commandTOs[i].getId()).setStatusCode("-1").setStatusMessage(e.getMessage()));
            }
        }
        CmdExecStatusesTO cmdExecStatusesTO = new CmdExecStatusesTO();
        cmdExecStatusesTO.setCmdExecStatusTO(res.toArray(new CmdExecStatusTO[res.size()]));
        cmdExecStatusesTO.setRevision(this.getRootRevision(accessTokenEntity, resourceTypeList));
        return cmdExecStatusesTO;
    }
}

