/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.command;

import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.command.IResourceCommand;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.utilities.SecureUtil;

public class DeleteCardCommand
implements IResourceCommand {
    private static Log LOG = LogFactory.getLog(DeleteCardCommand.class);
    public static final String COMMAND_ID = "Deleteorg.eclipse.higgins.sync.to.CardTO";
    private IResourceMetaDataService metaDataService = null;

    public DeleteCardCommand(IResourceMetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    public CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO) {
        CmdExecStatusTO cmdExecStatusTO = new CmdExecStatusTO().setId(commandTO.getId());
        try {
            CallbackHandler callbackHandler = SecureUtil.getCallbackHandler(accessTokenEntity);
            ICardRegistry.getInstance().deleteICard(callbackHandler, commandTO.getResourceId());
            RevisionEntity revisionEntity = this.metaDataService.findResourceRevisionEntity(new RevisionEntity().setResourceType("org.eclipse.higgins.sync.to.CardTO").setResourceId(commandTO.getResourceId()).setUserId(accessTokenEntity.getUserIdentifier()));
            if (null != revisionEntity) {
                this.metaDataService.persistResourceRevisionEntity(revisionEntity.setCommandName("Delete"));
            }
            cmdExecStatusTO.setStatusCode("0");
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            cmdExecStatusTO.setStatusCode("-1");
            cmdExecStatusTO.setStatusMessage(e.getMessage());
        }
        return cmdExecStatusTO;
    }
}

