/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.command.IResourceCommand;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.to.CardTO;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.utilities.ConverterHelper;
import org.eclipse.higgins.sync.utilities.SecureUtil;

public class GetCardCommand
implements IResourceCommand {
    private static Log LOG = LogFactory.getLog(GetCardCommand.class);
    public static final String COMMAND_ID = "Getorg.eclipse.higgins.sync.to.CardTO";
    private IResourceMetaDataService metaDataService = null;

    public GetCardCommand(IResourceMetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    public CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO) {
        CmdExecStatusTO cmdExecStatusTO = new CmdExecStatusTO().setId(commandTO.getId());
        try {
            CardTO res = null;
            ICard card = ICardRegistry.getInstance().getICardByCUID(SecureUtil.getCallbackHandler(accessTokenEntity), commandTO.getResourceId());
            if (null == card) {
                throw new NullPointerException("Couldn't find  card with :" + commandTO.getResourceId());
            }
            res = ConverterHelper.card2CardTO((IInformationCard)card);
            RevisionEntity revisionEntity = new RevisionEntity().setResourceType("org.eclipse.higgins.sync.to.CardTO").setResourceId(res.getId()).setUserId(accessTokenEntity.getUserIdentifier());
            res.setRevision(ConverterHelper.revisionEntity2RevisionTO(this.metaDataService.findResourceRevisionEntity(revisionEntity)));
            cmdExecStatusTO.setStatusCode("0").setResource(res);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            cmdExecStatusTO.setStatusCode("-1");
            cmdExecStatusTO.setStatusMessage(e.getMessage());
        }
        return cmdExecStatusTO;
    }
}

