/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.command.IResourceCommand;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.utilities.ResourceUtil;
import org.eclipse.higgins.sync.to.CardTO;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.utilities.ConverterHelper;
import org.eclipse.higgins.sync.utilities.SecureUtil;

public class PersistCardCommand
implements IResourceCommand {
    private static Log LOG = LogFactory.getLog(PersistCardCommand.class);
    public static final String COMMAND_ID = "Persistorg.eclipse.higgins.sync.to.CardTO";
    private IResourceMetaDataService metaDataService = null;

    public PersistCardCommand(IResourceMetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    public CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO) {
        CmdExecStatusTO cmdExecStatusTO = new CmdExecStatusTO().setId(commandTO.getId());
        try {
            CardTO cardTO = (CardTO)commandTO.getResource();
            CardTO res = null;
            InformationCard icard = ConverterHelper.cardTO2Card(cardTO);
            icard = (IInformationCard)ICardRegistry.getInstance().persistICard(SecureUtil.getCallbackHandler(accessTokenEntity), (ICard)icard);
            res = ConverterHelper.card2CardTO((IInformationCard)icard);
            RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision(this.metaDataService, accessTokenEntity.getUserIdentifier());
            ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
            revisionEntity.setResourceType("org.eclipse.higgins.sync.to.CardTO").setResourceId(res.getId()).setUserId(accessTokenEntity.getUserIdentifier()).setParentId(rootRevisionEntity.getId());
            this.metaDataService.persistResourceRevisionEntity((RevisionEntity)revisionEntity);
            res.setRevision(ConverterHelper.revisionEntity2RevisionTO((RevisionEntity)revisionEntity));
            cmdExecStatusTO.setStatusCode("0").setResource(res);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            cmdExecStatusTO.setStatusCode("-1");
            cmdExecStatusTO.setStatusMessage(e.getMessage());
        }
        return cmdExecStatusTO;
    }
}

