/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.command;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.command.IResourceCommand;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.utilities.ResourceUtil;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.to.UserProfileTO;
import org.eclipse.higgins.sync.utilities.ConverterHelper;
import org.eclipse.higgins.user.account.IUserAccountService;
import org.eclipse.higgins.user.profile.IUserProfileService;
import org.eclipse.higgins.user.profile.entity.UserProfile;

public class PersistUserProfileCommand
implements IResourceCommand {
    private static Log LOG = LogFactory.getLog(PersistUserProfileCommand.class);
    public static final String COMMAND_ID = "Persistorg.eclipse.higgins.sync.to.UserProfileTO";
    private IResourceMetaDataService metaDataService = null;
    private IUserProfileService userProfileService = null;
    private IUserAccountService userAccountService = null;

    public PersistUserProfileCommand(IResourceMetaDataService metaDataService, IUserProfileService userProfileService, IUserAccountService userAccountService) {
        this.metaDataService = metaDataService;
        this.userProfileService = userProfileService;
        this.userAccountService = userAccountService;
    }

    public CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO) {
        CmdExecStatusTO cmdExecStatusTO = new CmdExecStatusTO().setId(commandTO.getId());
        try {
            UserProfileTO userProfileTO = (UserProfileTO)commandTO.getResource();
            UserProfile userProfile = new UserProfile().setUserIdentifier((Serializable)((Object)accessTokenEntity.getUserIdentifier()));
            ConverterHelper.userProfileTO2UserProfile(userProfileTO, userProfile);
            this.userProfileService.modifyUserProfile((Serializable)((Object)accessTokenEntity.getUserIdentifier()), userProfile);
            RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision(this.metaDataService, accessTokenEntity.getUserIdentifier());
            ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
            revisionEntity.setResourceType(UserProfileTO.class.getCanonicalName()).setResourceId(accessTokenEntity.getUserIdentifier()).setUserId(accessTokenEntity.getUserIdentifier()).setParentId(rootRevisionEntity.getId());
            this.metaDataService.persistResourceRevisionEntity((RevisionEntity)revisionEntity);
            cmdExecStatusTO.setStatusCode("0").setResource(ConverterHelper.userProfile2UserProfileTO(userProfile, this.userAccountService.getAccount((Serializable)((Object)accessTokenEntity.getUserIdentifier())), (RevisionEntity)revisionEntity));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            cmdExecStatusTO.setStatusCode("-1");
            cmdExecStatusTO.setStatusMessage(e.getMessage());
        }
        return cmdExecStatusTO;
    }
}

