/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.utilities;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.IUIDescriptor;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.common.utils.XMLHelper;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.policy.ISTSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCardExtension;
import org.eclipse.higgins.icard.provider.cardspace.common.MCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.PCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.STSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.to.CardExtensionTO;
import org.eclipse.higgins.sync.to.CardTO;
import org.eclipse.higgins.sync.to.ClaimTO;
import org.eclipse.higgins.sync.to.ClaimTypeTO;
import org.eclipse.higgins.sync.to.ClaimUiDescriptorTO;
import org.eclipse.higgins.sync.to.CredentialDescriptorTO;
import org.eclipse.higgins.sync.to.EndpointReferenceTO;
import org.eclipse.higgins.sync.to.MCardTO;
import org.eclipse.higgins.sync.to.PCardTO;
import org.eclipse.higgins.sync.to.RevisionTO;
import org.eclipse.higgins.sync.to.StsPrivacyPolicyTO;
import org.eclipse.higgins.sync.to.TokenServiceTO;
import org.eclipse.higgins.sync.to.UserProfileTO;
import org.eclipse.higgins.user.account.Account;
import org.eclipse.higgins.user.profile.entity.UserProfile;
import org.w3c.dom.Element;

public class ConverterHelper {
    private static Log LOG = LogFactory.getLog(ConverterHelper.class);

    public static CardTO card2CardTO(IInformationCard cardEntity) {
        CardTO cardTO = null;
        try {
            if (null == cardEntity) {
                return null;
            }
            if (cardEntity instanceof IPersonalInformationCard) {
                cardTO = new PCardTO();
                ConverterHelper.card2CardTO(cardTO, cardEntity);
                ConverterHelper.pCardEntity2PCardTO((IPersonalInformationCard)cardEntity, cardTO);
            } else if (cardEntity instanceof IManagedInformationCard) {
                cardTO = new MCardTO();
                ConverterHelper.card2CardTO(cardTO, cardEntity);
                ConverterHelper.mCardEntity2MCardTO((IManagedInformationCard)cardEntity, (MCardTO)cardTO);
            } else {
                cardTO = new CardTO();
                ConverterHelper.card2CardTO(cardTO, cardEntity);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return cardTO;
    }

    public static CardExtensionTO cardExtension2CardExtensionTO(IInformationCardExtension extension) {
        CardExtensionTO extensionTO = new CardExtensionTO();
        extensionTO.setEnabled(extension.isEnabled());
        extensionTO.setExtensionXmlElement(extension.getElement().toString());
        return extensionTO;
    }

    public static IInformationCardExtension cardExtensionTO2CardExtension(CardExtensionTO extensionTO) {
        try {
            IOElement element = new IOElement();
            element.set((Object)extensionTO.getExtensionXmlElement());
            return new InformationCardExtension((IElement)element, extensionTO.getEnabled().booleanValue(), null);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private static void card2CardTO(CardTO cardTO, IInformationCard card) throws CardException {
        cardTO.setId(card.getCUID().toString());
        cardTO.setName(card.getName());
        cardTO.setCardId(card.getID().toString());
        cardTO.setIssuerName(card.getIssuerName());
        cardTO.setIssuer(card.getIssuer());
        cardTO.setImage(card.getImage());
        cardTO.setImageType(card.getImageType());
        cardTO.setIssuedTime(card.getTimeIssued());
        cardTO.setExpiredTime(card.getTimeExpires());
        cardTO.setSelfIssued(card.isSelfIssued());
        ArrayList<ClaimTypeTO> lst = new ArrayList<ClaimTypeTO>();
        Iterator itr = card.getSupportedClaimTypes();
        while (itr.hasNext()) {
            lst.add(ConverterHelper.claimType2ClaimTypeTO((IClaimType)itr.next()));
        }
        cardTO.setSupportedClaimTypes(lst.toArray(new ClaimTypeTO[lst.size()]));
        cardTO.setVersion(card.getVersion());
        List supportedTokenTypes = card.getSupportedTokenTypes();
        String[] tokenTypes = new String[supportedTokenTypes.size()];
        for (int i = 0; i < tokenTypes.length; ++i) {
            tokenTypes[i] = supportedTokenTypes.get(i).toString();
        }
        cardTO.setSupportedTokenTypes(tokenTypes);
        cardTO.setLastUpdatedTime(card.getTimeLastUpdated());
        cardTO.setIssuerID(card.getIssuerID());
        cardTO.setHashSalt(card.getHashSalt());
        cardTO.setMasterKey(card.getRawMasterKey());
        IInformationCardExtension[] extensions = card.getExtensions();
        if (extensions != null && extensions.length > 0) {
            CardExtensionTO[] cardExtensionTOs = new CardExtensionTO[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                cardExtensionTOs[i] = ConverterHelper.cardExtension2CardExtensionTO(extensions[i]);
            }
            cardTO.setExtensions(cardExtensionTOs);
        }
    }

    public static InformationCard cardTO2Card(CardTO cardTO) {
        PCardEntity cardEntity = null;
        if (cardTO instanceof PCardTO) {
            cardEntity = new PCardEntity();
            ConverterHelper.cardTO2CardEntity(cardTO, (InformationCard)cardEntity);
            ConverterHelper.pCardTO2PCardEntity((PCardTO)cardTO, cardEntity);
        } else if (cardTO instanceof MCardTO) {
            cardEntity = new MCardEntity();
            ConverterHelper.cardTO2CardEntity(cardTO, (InformationCard)cardEntity);
            ConverterHelper.mCardTO2MCardEntity((MCardTO)cardTO, (MCardEntity)cardEntity);
        }
        return cardEntity;
    }

    private static void cardTO2CardEntity(CardTO cardTO, InformationCard cardEntity) {
        try {
            cardEntity.setID(new URI(cardTO.getCardId()));
            cardEntity.setName(cardTO.getName());
            cardEntity.setIssuerName(cardTO.getIssuerName());
            cardEntity.setIssuer(cardTO.getIssuer());
            cardEntity.setImage(cardTO.getImage());
            cardEntity.setImageType(cardTO.getImageType());
            cardEntity.setTimeIssued(cardTO.getIssuedTime() != null ? cardTO.getIssuedTime() : new Date());
            cardEntity.setTimeExpires(cardTO.getExpiredTime());
            ArrayList<IClaimType> claimTypes = new ArrayList<IClaimType>();
            ClaimTypeTO[] supportedClaimTypes = cardTO.getSupportedClaimTypes();
            for (int i = 0; i < supportedClaimTypes.length; ++i) {
                claimTypes.add(ConverterHelper.claimTypeTO2ClaimType(supportedClaimTypes[i]));
            }
            cardEntity.setSupportedClaimTypes(claimTypes);
            cardEntity.setVersion(cardTO.getVersion());
            cardEntity.setSupportedTokenTypes(Arrays.asList(cardTO.getSupportedTokenTypes()));
            cardEntity.setTimeLastUpdated(cardTO.getLastUpdatedTime() != null ? cardTO.getLastUpdatedTime() : new Date());
            cardEntity.setIssuerID(cardTO.getIssuerID());
            cardEntity.setHashSalt(cardTO.getHashSalt());
            cardEntity.setRawMasterKey(cardTO.getMasterKey());
            CardExtensionTO[] extensions = cardTO.getExtensions();
            if (extensions != null && extensions.length > 0) {
                ArrayList<IInformationCardExtension> cardExtensions = new ArrayList<IInformationCardExtension>();
                for (int i = 0; i < extensions.length; ++i) {
                    cardExtensions.add(ConverterHelper.cardExtensionTO2CardExtension(extensions[i]));
                }
                cardEntity.setExtensions(cardExtensions);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public static ClaimTypeTO claimType2ClaimTypeTO(IClaimType claimType) {
        ClaimTypeTO claimTypeTO = new ClaimTypeTO();
        claimTypeTO.setDescription(claimType.getDescription());
        claimTypeTO.setDisplayName(claimType.getDisplayName());
        claimTypeTO.setIsSimple(claimType.isSimple());
        claimTypeTO.setType(claimType.getType());
        return claimTypeTO;
    }

    public static ClaimUiDescriptorTO claimType2ClaimUiDescriptor(IClaimType claimType) {
        ClaimUiDescriptorTO claimUiDescriptorTO = new ClaimUiDescriptorTO();
        IUIDescriptor uiDescriptor = claimType.getUIDescriptor();
        if (null != uiDescriptor) {
            claimUiDescriptorTO.setInputMask(uiDescriptor.getInputMask());
            if (null != uiDescriptor.getOptionalValues() && uiDescriptor.getOptionalValues().size() > 0) {
                claimUiDescriptorTO.setOptionalValues(uiDescriptor.getOptionalValues().toArray(new String[uiDescriptor.getOptionalValues().size()]));
            }
            claimUiDescriptorTO.setPattern(uiDescriptor.getPattern());
            claimUiDescriptorTO.setType("" + uiDescriptor.getType());
        }
        return claimUiDescriptorTO;
    }

    public static IClaimType claimTypeTO2ClaimType(ClaimTypeTO claimTypeTO) {
        try {
            return new ClaimType(claimTypeTO.getType(), claimTypeTO.getDisplayName(), claimTypeTO.getDescription());
        }
        catch (CardException e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private static void pCardEntity2PCardTO(IPersonalInformationCard pcardEntity, PCardTO pcardTO) {
        try {
            pcardTO.setPinDigest(pcardEntity.getPinDigest());
            ArrayList<ClaimTO> claimList = new ArrayList<ClaimTO>();
            Map claimMap = pcardEntity.getDirtyClaims();
            Iterator iterator = pcardEntity.getSupportedClaimTypes();
            while (iterator.hasNext()) {
                IClaimType claimTypeItem = (IClaimType)iterator.next();
                claimList.add(new ClaimTO().setClaimType(ConverterHelper.claimType2ClaimTypeTO(claimTypeItem)).setValues(new String[]{(String)claimMap.get(claimTypeItem.getType())}).setClaimUiDescriptor(ConverterHelper.claimType2ClaimUiDescriptor(claimTypeItem)));
            }
            pcardTO.setClaims(claimList.toArray(new ClaimTO[claimList.size()]));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    private static CredentialDescriptorTO credentialDescriptor2CredentialDescriptorTO(ICredentialDescriptor credentialDescriptor, CredentialDescriptorTO credentialDescriptorTO) throws IOException {
        return credentialDescriptorTO.setType(credentialDescriptor.getType()).setDisplayCredentialHint(credentialDescriptor.getDisplayCredentialHint()).setCredentialXmlElement(XMLHelper.toString((Element)credentialDescriptor.asXML()));
    }

    private static EndpointReferenceTO endpointReference2EndpointReferenceTO(IEndpointReference endpointReference, EndpointReferenceTO endpointReferenceTO) throws IOException {
        return endpointReferenceTO.setAddress(endpointReference.getAddress()).setIdentityXml(XMLHelper.toString((Element)endpointReference.getIdentity())).setMetadataAddress(endpointReference.getMetadataAddress()).setMetadataXml(XMLHelper.toString((Element)endpointReference.getMetadata()));
    }

    private static TokenServiceTO tokenService2TokenServiceTO(TokenService tokenService, TokenServiceTO tokenServiceTO) throws IOException {
        tokenServiceTO.setEndpointReference(ConverterHelper.endpointReference2EndpointReferenceTO(tokenService.getEndpointReference(), new EndpointReferenceTO()));
        ICredentialDescriptor userCredential = tokenService.getUserCredential();
        tokenServiceTO.setUserCredential(ConverterHelper.credentialDescriptor2CredentialDescriptorTO(userCredential, new CredentialDescriptorTO()));
        return tokenServiceTO;
    }

    private static MCardTO mCardEntity2MCardTO(IManagedInformationCard mcardEntity, MCardTO mcardTO) {
        try {
            mcardTO.setRequireAppliesTo(mcardEntity.getRequireAppliesTo());
            ISTSPrivacyPolicy policy = mcardEntity.getPrivacyNotice();
            if (policy != null) {
                mcardTO.setStsPrivacyPolicyTO(new StsPrivacyPolicyTO().setUrl(policy.getPrivacyUrl()).setVersion(policy.getPrivacyVersion()));
            }
            List tslist = mcardEntity.getTokenServices();
            TokenServiceTO[] serviceTOs = new TokenServiceTO[tslist.size()];
            for (int i = 0; i < serviceTOs.length; ++i) {
                serviceTOs[i] = ConverterHelper.tokenService2TokenServiceTO((TokenService)tslist.get(i), new TokenServiceTO());
            }
            mcardTO.setTokenServices(serviceTOs);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return mcardTO;
    }

    private static void pCardTO2PCardEntity(PCardTO pcardTO, PCardEntity pcardEntity) {
        try {
            pcardEntity.setPinDigest(pcardTO.getPinDigest());
            pcardEntity.setSelfIssued(true);
            HashMap<String, String> claimMap = new HashMap<String, String>();
            ClaimTO[] claimTOs = pcardTO.getClaims();
            if (null != claimTOs) {
                for (int i = 0; i < claimTOs.length; ++i) {
                    try {
                        claimMap.put(claimTOs[i].getClaimType().getType(), claimTOs[i].getValues()[0]);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                }
            }
            pcardEntity.setDirtyClaims(claimMap);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    private static MCardEntity mCardTO2MCardEntity(MCardTO mcardTO, MCardEntity mcardEntity) {
        try {
            mcardEntity.setRequireAppliesTo(mcardTO.getRequireAppliesTo());
            if (null != mcardTO.getStsPrivacyPolicyTO()) {
                STSPrivacyPolicy policy = new STSPrivacyPolicy(mcardTO.getStsPrivacyPolicyTO().getUrl(), mcardTO.getStsPrivacyPolicyTO().getVersion());
                mcardEntity.setPrivacyNotice((ISTSPrivacyPolicy)policy);
            }
            TokenServiceTO[] tokenServices = mcardTO.getTokenServices();
            ArrayList<TokenService> tokenServiceList = new ArrayList<TokenService>();
            for (int i = 0; i < tokenServices.length; ++i) {
                EndpointReference endpointReference = new EndpointReference(tokenServices[i].getEndpointReference().getAddress(), tokenServices[i].getEndpointReference().getMetadataXml(), tokenServices[i].getEndpointReference().getIdentityXml());
                CredentialDescriptor credentialDescriptor = new CredentialDescriptor(tokenServices[i].getUserCredential().getDisplayCredentialHint(), tokenServices[i].getUserCredential().getCredentialXmlElement());
                tokenServiceList.add(new TokenService(endpointReference, credentialDescriptor));
            }
            mcardEntity.setTokenServices(tokenServiceList);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return mcardEntity;
    }

    public static RevisionTO revisionEntity2RevisionTO(RevisionEntity entity) {
        RevisionTO to = new RevisionTO();
        try {
            to.setModifiedTime(entity.getModifiedTime());
            to.setNumber(entity.getNumber());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return to;
    }

    public static RevisionEntity revisionTO2revisionEntity(RevisionTO to) {
        RevisionEntity entity = new RevisionEntity();
        try {
            entity.setModifiedTime(to.getModifiedTime());
            entity.setNumber(to.getNumber());
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return entity;
    }

    public static UserProfile userProfileTO2UserProfile(UserProfileTO userProfileTO, UserProfile userProfile) {
        try {
            userProfile.setEmail(userProfileTO.getEmail());
            userProfile.setFirstName(userProfileTO.getFirstName());
            userProfile.setLastName(userProfileTO.getLastName());
            userProfile.setSms(userProfileTO.getMobile());
            userProfile.setReferralTracking(userProfileTO.getReferralTracking());
            userProfile.setSendMeNews(userProfileTO.getSendMeNews().booleanValue());
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return userProfile;
    }

    public static UserProfileTO userProfile2UserProfileTO(UserProfile userProfile, Account account, RevisionEntity revisionEntity) {
        UserProfileTO to = new UserProfileTO();
        try {
            to.setId((String)((Object)userProfile.getUserIdentifier()));
            to.setCreatedTime(userProfile.getCreated());
            to.setEmail(userProfile.getEmail());
            to.setFirstName(userProfile.getFirstName());
            to.setLastName(userProfile.getLastName());
            to.setLoginName(account.getLogin());
            to.setMobile(userProfile.getSms());
            to.setReferralTracking(userProfile.getReferralTracking());
            to.setSendMeNews(userProfile.isSendMeNews());
            to.setRevision(ConverterHelper.revisionEntity2RevisionTO(revisionEntity));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return to;
    }
}

