/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.utilities;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.to.AuthCredentialTO;
import org.eclipse.higgins.sync.to.UsernamePasswordAuthCredentialTO;

public class SecureUtil {
    public static CallbackHandler getCallbackHandler(final AuthCredentialTO authCredentialTO) {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(authCredentialTO instanceof UsernamePasswordAuthCredentialTO ? ((UsernamePasswordAuthCredentialTO)authCredentialTO).getUsername() : null);
                        continue;
                    }
                    if (!(callbacks[i] instanceof PasswordCallback)) continue;
                    ((PasswordCallback)callbacks[i]).setPassword(authCredentialTO instanceof UsernamePasswordAuthCredentialTO ? ((UsernamePasswordAuthCredentialTO)authCredentialTO).getPassword().toCharArray() : null);
                }
            }
        };
    }

    public static CallbackHandler getCallbackHandler(String username, String password) {
        return SecureUtil.getCallbackHandler(new UsernamePasswordAuthCredentialTO().setPassword(password).setUsername(username));
    }

    public static CallbackHandler getCallbackHandler(AccessTokenEntity accessTokenEntity) {
        return SecureUtil.getCallbackHandler(new UsernamePasswordAuthCredentialTO().setUsername(accessTokenEntity.getUserIdentifier()));
    }

    public static Context getContext() throws NamingException {
        InitialContext initCtx = new InitialContext();
        return (Context)initCtx.lookup("java:comp/env");
    }
}

