/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.command;

import javax.security.auth.callback.CallbackHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.utilities.SecureUtil;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class DeleteCardCommand implements IResourceCommand {

	private static Log LOG = LogFactory.getLog(DeleteCardCommand.class);

	public static final String COMMAND_ID = IResourceCommand.DELETE_CMD_NAME
			+ IResourceMetaDataService.CARD_RESOURCE_TYPE;

	private IResourceMetaDataService metaDataService = null;

	/**
	 * @param metaDataService
	 */
	public DeleteCardCommand(IResourceMetaDataService metaDataService) {
		super();
		this.metaDataService = metaDataService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.sync.command.IResourceCommand#execCmd(org.eclipse.higgins.sync.auth.entity.AccessTokenEntity,
	 * org.eclipse.higgins.sync.to.CommandTO)
	 */
	public CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO) {
		CmdExecStatusTO cmdExecStatusTO = new CmdExecStatusTO().setId(commandTO.getId());
		try {
			CallbackHandler callbackHandler = SecureUtil.getCallbackHandler(accessTokenEntity);

			// ICard card = ICardRegistry.getInstance().getICardByCUID(callbackHandler, commandTO.getResourceId());

			// delete ICard
			ICardRegistry.getInstance().deleteICard(callbackHandler, commandTO.getResourceId());

			// load RevisionEntity
			RevisionEntity revisionEntity = metaDataService.findResourceRevisionEntity(new RevisionEntity()
					.setResourceType(IResourceMetaDataService.CARD_RESOURCE_TYPE).setResourceId(
							commandTO.getResourceId()).setUserId(accessTokenEntity.getUserIdentifier()));

			if (null != revisionEntity) {
				// update meta-data
				metaDataService.persistResourceRevisionEntity(revisionEntity
						.setCommandName(IResourceCommand.DELETE_CMD_NAME));
			}

			cmdExecStatusTO.setStatusCode("0");
		} catch (Exception e) {
			LOG.error(e, e);
			cmdExecStatusTO.setStatusCode("-1");
			cmdExecStatusTO.setStatusMessage(e.getMessage());
		}
		return cmdExecStatusTO;

	}
}
