/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.to.CardTO;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.utilities.ConverterHelper;
import org.eclipse.higgins.sync.utilities.SecureUtil;

/**
 * Load Card by using resource id.
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class GetCardCommand implements IResourceCommand {

	private static Log LOG = LogFactory.getLog(GetCardCommand.class);

	public static final String COMMAND_ID = IResourceCommand.GET_CMD_NAME + IResourceMetaDataService.CARD_RESOURCE_TYPE;

	private IResourceMetaDataService metaDataService = null;

	/**
	 * @param metaDataService
	 */
	public GetCardCommand(IResourceMetaDataService metaDataService) {
		super();
		this.metaDataService = metaDataService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.sync.cmd.ResourceCommand#execCmd(org.eclipse.higgins.sync.to.CommandTO)
	 */
	public CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO) {
		CmdExecStatusTO cmdExecStatusTO = new CmdExecStatusTO().setId(commandTO.getId());
		try {
			CardTO res = null;
			ICard card = ICardRegistry.getInstance().getICardByCUID(SecureUtil.getCallbackHandler(accessTokenEntity),
					commandTO.getResourceId());
			if (null == card) {
				throw new NullPointerException("Couldn't find  card with :" + commandTO.getResourceId());
			}

			res = ConverterHelper.card2CardTO((IInformationCard) card);
			// load RevisionEntity
			RevisionEntity revisionEntity = new RevisionEntity().setResourceType(
					IResourceMetaDataService.CARD_RESOURCE_TYPE).setResourceId(res.getId()).setUserId(
					accessTokenEntity.getUserIdentifier());
			res.setRevision(ConverterHelper.revisionEntity2RevisionTO(metaDataService
					.findResourceRevisionEntity(revisionEntity)));

			cmdExecStatusTO.setStatusCode("0").setResource(res);

		} catch (Exception e) {
			LOG.error(e, e);
			cmdExecStatusTO.setStatusCode("-1");
			cmdExecStatusTO.setStatusMessage(e.getMessage());
		}
		return cmdExecStatusTO;
	}
}
