/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.utilities.ResourceUtil;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.to.UserProfileTO;
import org.eclipse.higgins.sync.utilities.ConverterHelper;
import org.eclipse.higgins.user.account.IUserAccountService;
import org.eclipse.higgins.user.profile.IUserProfileService;
import org.eclipse.higgins.user.profile.entity.UserProfile;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class GetUserProfileCommand implements IResourceCommand {
	private static Log LOG = LogFactory.getLog(GetUserProfileCommand.class);

	public static final String COMMAND_ID = IResourceCommand.GET_CMD_NAME
			+ IResourceMetaDataService.USER_PROFILE_RESOURCE_TYPE;

	private IResourceMetaDataService metaDataService = null;
	private IUserProfileService userProfileService = null;
	private IUserAccountService userAccountService = null;

	/**
	 * @param metaDataService
	 * @param userProfileService
	 * @param userAccountService
	 */
	public GetUserProfileCommand(IResourceMetaDataService metaDataService, IUserProfileService userProfileService,
			IUserAccountService userAccountService) {
		super();
		this.metaDataService = metaDataService;
		this.userProfileService = userProfileService;
		this.userAccountService = userAccountService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.sync.cmd.ResourceCommand#execCmd(org.eclipse.higgins.sync.to.CommandTO)
	 */
	public CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO) {
		CmdExecStatusTO cmdExecStatusTO = new CmdExecStatusTO().setId(commandTO.getId());
		try {
			UserProfile userProfile = userProfileService.getUserProfile(accessTokenEntity.getUserIdentifier());

			// find root (parent) revision entity
			RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision(metaDataService, accessTokenEntity
					.getUserIdentifier());

			// update RevisionEntity
			ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
			revisionEntity.setResourceType(UserProfileTO.class.getCanonicalName()).setResourceId(
					accessTokenEntity.getUserIdentifier()).setUserId(accessTokenEntity.getUserIdentifier())
					.setParentId(rootRevisionEntity.getId());

			// metaDataService.persistResourceRevisionEntity(revisionEntity);

			cmdExecStatusTO.setStatusCode("0").setResource(
					ConverterHelper.userProfile2UserProfileTO(userProfile, userAccountService
							.getAccount(accessTokenEntity.getUserIdentifier()), metaDataService
							.findResourceRevisionEntity(revisionEntity)));
		} catch (Exception e) {
			LOG.error(e, e);
			cmdExecStatusTO.setStatusCode("-1");
			cmdExecStatusTO.setStatusMessage(e.getMessage());
		}
		return cmdExecStatusTO;
	}

}
