/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.command;

import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;

/**
 * @author Alexander Yuhimenko
 * 
 */
public interface IResourceCommand {

	public static final String PERSIST_CMD_NAME = "Persist";
	public static final String DELETE_CMD_NAME = "Delete";
	public static final String GET_CMD_NAME = "Get";

	/**
	 * Execute command.
	 * 
	 * @param accessTokenEntity
	 * @param commandTO
	 * @return
	 */
	CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO);

}
