/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.utilities.ResourceUtil;
import org.eclipse.higgins.sync.to.CardTO;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.utilities.ConverterHelper;
import org.eclipse.higgins.sync.utilities.SecureUtil;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class PersistCardCommand implements IResourceCommand {

	private static Log LOG = LogFactory.getLog(PersistCardCommand.class);

	public static final String COMMAND_ID = IResourceCommand.PERSIST_CMD_NAME
			+ IResourceMetaDataService.CARD_RESOURCE_TYPE;

	private IResourceMetaDataService metaDataService = null;

	/**
	 * @param metaDataService
	 */
	public PersistCardCommand(IResourceMetaDataService metaDataService) {
		this.metaDataService = metaDataService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.sync.command.IResourceCommand#execCmd(org.eclipse.higgins.sync.auth.entity.AccessTokenEntity,
	 * org.eclipse.higgins.sync.to.CommandTO)
	 */
	public CmdExecStatusTO execCmd(AccessTokenEntity accessTokenEntity, CommandTO commandTO) {
		CmdExecStatusTO cmdExecStatusTO = new CmdExecStatusTO().setId(commandTO.getId());
		try {
			// if (commandTO.getResource() instanceof CardTO) {
			CardTO cardTO = (CardTO) commandTO.getResource();

			// TODO add validation revision number.
			CardTO res = null;
			IInformationCard icard = ConverterHelper.cardTO2Card(cardTO);
			icard = (IInformationCard) ICardRegistry.getInstance().persistICard(
					SecureUtil.getCallbackHandler(accessTokenEntity), icard);
			res = ConverterHelper.card2CardTO(icard);

			// find root (parent) revision entity
			RevisionEntity rootRevisionEntity = new ResourceUtil().findRootRevision(metaDataService, accessTokenEntity
					.getUserIdentifier());

			ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
			revisionEntity.setResourceType(IResourceMetaDataService.CARD_RESOURCE_TYPE).setResourceId(res.getId())
					.setUserId(accessTokenEntity.getUserIdentifier()).setParentId(rootRevisionEntity.getId());

			metaDataService.persistResourceRevisionEntity(revisionEntity);

			// set revision
			res.setRevision(ConverterHelper.revisionEntity2RevisionTO(revisionEntity));

			cmdExecStatusTO.setStatusCode("0").setResource(res);

			// }
		} catch (Exception e) {
			LOG.error(e, e);
			cmdExecStatusTO.setStatusCode("-1");
			cmdExecStatusTO.setStatusMessage(e.getMessage());
		}
		return cmdExecStatusTO;
	}

}
