/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * AccessToken transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class AccessTokenTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 *Represents token identifier.
	 */
	private String id;

	/**
	 *Represents issued date time.
	 */
	private Date issuedTime;

	/**
	 * Represents max idle time in seconds.
	 */
	private Integer maxIdleTime;

	/**
	 * Represents  maximum live time in seconds.
	 */
	private Integer maxLiveTime;

	/**
	 * @return the maxLiveTime
	 */
	public Integer getMaxLiveTime() {
		return maxLiveTime;
	}

	/**
	 * @param maxLiveTime
	 *            the maxLiveTime to set
	 */
	public AccessTokenTO setMaxLiveTime(Integer maxLiveTime) {
		this.maxLiveTime = maxLiveTime;
		return this;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return the issuedTime
	 */
	public Date getIssuedTime() {
		return issuedTime;
	}

	/**
	 * @return the maxIdleTime
	 */
	public Integer getMaxIdleTime() {
		return maxIdleTime;
	}

	/**
	 * Represents token identifier.
	 * 
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @param issuedTime
	 *            the issuedTime to set
	 */
	public void setIssuedTime(Date issuedTime) {
		this.issuedTime = issuedTime;
	}

	/**
	 * @param maxIdleTime
	 *            the maxIdleTime to set
	 */
	public void setMaxIdleTime(Integer maxIdleTime) {
		this.maxIdleTime = maxIdleTime;
	}

}
