/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Base transfer object. All resources should extend it.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace="http://www.eclipse.org/higgins/cardsync/2009/")
public class BaseTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents unique resource server identifier.
	 */
	private String id;

	/**
	 * Represents revision information.
	 */
	private RevisionTO revision;

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return the revision
	 */
	public RevisionTO getRevision() {
		return revision;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @param revision
	 *            the revision to set
	 */
	public void setRevision(RevisionTO revision) {
		this.revision = revision;
	}

}
