/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Card category transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace="http://www.eclipse.org/higgins/cardsync/2009/")
public class CardCategoryTO extends BaseTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// /**
	// * Represents category identifier. Unique within user account.
	// */
	// private String id;

	/**
	 * Represents parent category identifier.
	 */
	private String parentId;

	/**
	 * Represents category name.
	 */
	private String name;

	/**
	 * Represents associated card id array.
	 */
	private String[] cuids;

	/**
	 * Represents category index. It needs for ordering category on client.
	 */
	private int idx;

	/**
	 * Represents category type.
	 */
	private String type;

	/**
	 * @return the cuids
	 */
	public String[] getCuids() {
		return cuids;
	}

	/**
	 * @return the idx
	 */
	public int getIdx() {
		return idx;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the parentId
	 */
	public String getParentId() {
		return parentId;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param cuids
	 *            the cuids to set
	 */
	public void setCuids(String[] cuids) {
		this.cuids = cuids;
	}

	/**
	 * @param idx
	 *            the idx to set
	 */
	public void setIdx(int idx) {
		this.idx = idx;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @param parentId the parentId to set
	 */
	public CardCategoryTO setParentId(String parentId) {
		this.parentId = parentId;
		return this;
	}

	/**
	 * @param type the type to set
	 */
	public CardCategoryTO setType(String type) {
		this.type = type;
		return this;
	}

}
