/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * CardExtension transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class CardExtensionTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Is extension enabled.
	 */
	private Boolean enabled;

	/**
	 *Represents extension element data.
	 */
	private String extensionXmlElement;

	/**
	 * @return the enabled
	 */
	public Boolean getEnabled() {
		return enabled;
	}

	/**
	 * @return the extensionElement
	 */
	public String getExtensionXmlElement() {
		return extensionXmlElement;
	}

	/**
	 * @param enabled
	 *            the enabled to set
	 */
	public void setEnabled(final Boolean enabled) {
		this.enabled = enabled;
	}

	/**
	 * @param extensionElement
	 *            the extensionElement to set
	 */
	public void setExtensionXmlElement(final String extensionElement) {
		this.extensionXmlElement = extensionElement;
	}

}
