/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Card history transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace="http://www.eclipse.org/higgins/cardsync/2009/")
public class CardHistoryTO extends BaseTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents html web form elements. It needs for supporting auto-login.
	 */
	private WebFormTO form;

	/**
	 * Represents date time of card usage.
	 */
	private Date date;

	/**
	 * @return the date
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * @return the form
	 */
	public WebFormTO getForm() {
		return form;
	}

	/**
	 * @param date
	 *            the date to set
	 */
	public void setDate(final Date date) {
		this.date = date;
	}

	/**
	 * @param form
	 *            the form to set
	 */
	public void setForm(final WebFormTO form) {
		this.form = form;
	}

}
