	/** 
	 * Copyright (c) 2009 Parity Communications, Inc.  
	 * All rights reserved. This program and the accompanying materials  
	 * are made available under the terms of the Eclipse Public License v1.0  
	 * which accompanies this distribution, and is available at 
	 * http://www.eclipse.org/legal/epl-v10.html 
	 *  
	 * Contributors: 
	 * Alexander Yuhimenko - implementation 
	 * 
	 */

	package org.eclipse.higgins.sync.to;

	import java.io.Serializable;
	import java.util.Date;
	import javax.xml.bind.annotation.XmlRootElement;

	/**
	 * Card transfer object.
	 * 
	 * @see org.eclipse.higgins.icard.io.IElement.IInformationCard
	 * @see org.eclipse.higgins.icard.ICard
	 * 
	 * @author Alexander Yuhimenko
	 * 
	 */
	@XmlRootElement(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
	public class CardTO extends BaseTO implements Serializable {

		/**
	 *  
	 */
		private static final long serialVersionUID = 1L;

		/**
		 * Represents card identifier.
		 */
		private String cardId;

		/**
		 *Card version.
		 */
		private String version;

		/**
		 * Human friendly card name.
		 */
		private String name;

		/**
		 *Card image.
		 */
		private byte[] image;

		/**
		 *Card image mime type.
		 */
		private String imageType;

		/**
		 * Card issuer name.
		 */
		private String issuer = null;

		/**
		 * Human friendly card issuer name.
		 */
		private String issuerName;

		/**
		 *Issued(created) time.
		 */
		private Date issuedTime;

		/**
		 * Card expired date.
		 */
		private Date expiredTime;

		/**
		 *Last card updated date.
		 */
		private Date lastUpdatedTime;

		/**
		 * Represents array of all possible types of claim that are supported.
		 */
		private ClaimTypeTO[] supportedClaimTypes;

		/**
		 * Represents arrays of token types which can be provided for this card.
		 */
		private String[] supportedTokenTypes;

		/**
		 * Is card self issued. True for p-card and pwm-card. False fro m-card
		 */
		private Boolean selfIssued;

		/**
		 *Card claims.
		 */
		private ClaimTO[] claims;

		/**
		 * Card hash salt.
		 */
		private byte[] hashSalt;

		/**
		 * Card master key.
		 */
		private byte[] masterKey;

		/**
		 * Card issuer identifier.
		 */
		private byte[] issuerID = null;

		/**
		 *Card extensions.
		 */
		private CardExtensionTO[] extensions;

		/**
		 * Getter of the property <tt>cardId</tt>
		 * 
		 * @return Returns the cardId.
		 * 
		 */

		public String getCardId() {
			return cardId;
		}

		/**
		 * @return the claims
		 */
		public ClaimTO[] getClaims() {
			return claims;
		}

		/**
		 * @return the expiredTime
		 */
		public Date getExpiredTime() {
			return expiredTime;
		}

		/**
		 * @return the extensions
		 */
		public CardExtensionTO[] getExtensions() {
			return extensions;
		}

		/**
		 * @return the hashSalt
		 */
		public byte[] getHashSalt() {
			return hashSalt;
		}

		/**
		 * @return the image
		 */
		public byte[] getImage() {
			return image;
		}

		/**
		 * @return the imageType
		 */
		public String getImageType() {
			return imageType;
		}

		/**
		 * @return the issuedTime
		 */
		public Date getIssuedTime() {
			return issuedTime;
		}

		/**
		 * @return the issuer
		 */
		public String getIssuer() {
			return issuer;
		}

		/**
		 * @return the issuerID
		 */
		public byte[] getIssuerID() {
			return issuerID;
		}

		/**
		 * @return the issuerName
		 */
		public String getIssuerName() {
			return issuerName;
		}

		/**
		 * @return the lastUpdatedTime
		 */
		public Date getLastUpdatedTime() {
			return lastUpdatedTime;
		}

		/**
		 * @return the masterKey
		 */
		public byte[] getMasterKey() {
			return masterKey;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @return the selfIssued
		 */
		public Boolean getSelfIssued() {
			return selfIssued;
		}

		/**
		 * @return the supportedClaimTypes
		 */
		public ClaimTypeTO[] getSupportedClaimTypes() {
			return supportedClaimTypes;
		}

		/**
		 * @return the supportedTokenTypes
		 */
		public String[] getSupportedTokenTypes() {
			return supportedTokenTypes;
		}

		/**
		 * @return the version
		 */
		public String getVersion() {
			return version;
		}

		/**
		 * Setter of the property <tt>cardId</tt>
		 * 
		 * @param cardId
		 *            The cardId to set.
		 * 
		 */
		public void setCardId(String cardId) {
			this.cardId = cardId;
		}

		/**
		 * @param claims
		 *            the claims to set
		 */
		public void setClaims(final ClaimTO[] claims) {
			this.claims = claims;
		}

		/**
		 * @param expiredTime
		 *            the expiredTime to set
		 */
		public void setExpiredTime(final Date expiredTime) {
			this.expiredTime = expiredTime;
		}

		/**
		 * @param extensions
		 *            the extensions to set
		 */
		public void setExtensions(final CardExtensionTO[] extensions) {
			this.extensions = extensions;
		}

		/**
		 * @param hashSalt
		 *            the hashSalt to set
		 */
		public void setHashSalt(final byte[] hashSalt) {
			this.hashSalt = hashSalt;
		}

		/**
		 * @param image
		 *            the image to set
		 */
		public void setImage(final byte[] image) {
			this.image = image;
		}

		/**
		 * @param imageType
		 *            the imageType to set
		 */
		public void setImageType(final String imageType) {
			this.imageType = imageType;
		}

		/**
		 * @param issuedTime
		 *            the issuedTime to set
		 */
		public void setIssuedTime(final Date issuedTime) {
			this.issuedTime = issuedTime;
		}

		/**
		 * @param issuer
		 *            the issuer to set
		 */
		public void setIssuer(final String issuer) {
			this.issuer = issuer;
		}

		/**
		 * @param issuerID
		 *            the issuerID to set
		 */
		public void setIssuerID(final byte[] issuerID) {
			this.issuerID = issuerID;
		}

		/**
		 * @param issuerName
		 *            the issuerName to set
		 */
		public void setIssuerName(final String issuerName) {
			this.issuerName = issuerName;
		}

		/**
		 * @param lastUpdatedTime
		 *            the lastUpdatedTime to set
		 */
		public void setLastUpdatedTime(final Date lastUpdatedTime) {
			this.lastUpdatedTime = lastUpdatedTime;
		}

		/**
		 * @param masterKey
		 *            the masterKey to set
		 */
		public void setMasterKey(final byte[] masterKey) {
			this.masterKey = masterKey;
		}

		/**
		 * @param name
		 *            the name to set
		 */
		public void setName(final String name) {
			this.name = name;
		}

		/**
		 * @param selfIssued
		 *            the selfIssued to set
		 */
		public void setSelfIssued(final Boolean selfIssued) {
			this.selfIssued = selfIssued;
		}

		/**
		 * @param supportedClaimTypes
		 *            the supportedClaimTypes to set
		 */
		public void setSupportedClaimTypes(ClaimTypeTO[] supportedClaimTypes) {
			this.supportedClaimTypes = supportedClaimTypes;
		}

		/**
		 * @param supportedTokenTypes
		 *            the supportedTokenTypes to set
		 */
		public void setSupportedTokenTypes(final String[] supportedTokenTypes) {
			this.supportedTokenTypes = supportedTokenTypes;
		}

		/**
		 * @param version
		 *            the version to set
		 */
		public void setVersion(final String version) {
			this.version = version;
		}

	}
