/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents Card container.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class CardsTO extends BaseTO {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represent card array.
	 */
	private CardTO[] cards;

	/**
	 * @return the cards
	 */
	public CardTO[] getCards() {
		return cards;
	}

	/**
	 * @param cards
	 *            the cards to set
	 */
	public CardsTO setCards(CardTO[] cards) {
		this.cards = cards;
		return this;
	}

}
