/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * Card claim transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class ClaimTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Contains sub-claims if claim is complex claim.
	 */
	private ClaimTO[] claims;

	/**
	 *Represents claim type
	 */
	private ClaimTypeTO claimType;

	/**
	 *Represents meta information for building user friendly claim editor.
	 */
	private ClaimUiDescriptorTO claimUiDescriptor;

	/**
	 *Represents claim values.
	 */
	private String[] values;

	/**
	 * @return the claims
	 */
	public ClaimTO[] getClaims() {
		return claims;
	}

	/**
	 * @return the claimType
	 */
	public ClaimTypeTO getClaimType() {
		return claimType;
	}

	/**
	 * @return the claimUiDescriptor
	 */
	public ClaimUiDescriptorTO getClaimUiDescriptor() {
		return claimUiDescriptor;
	}

	/**
	 * @return the values
	 */
	public String[] getValues() {
		return values;
	}

	/**
	 * @param claims the claims to set
	 */
	public ClaimTO setClaims(ClaimTO[] claims) {
		this.claims = claims;
		return this;
	}

	/**
	 * @param claimType the claimType to set
	 */
	public ClaimTO setClaimType(ClaimTypeTO claimType) {
		this.claimType = claimType;
		return this;
	}

	/**
	 * @param claimUiDescriptor the claimUiDescriptor to set
	 */
	public ClaimTO setClaimUiDescriptor(ClaimUiDescriptorTO claimUiDescriptor) {
		this.claimUiDescriptor = claimUiDescriptor;
		return this;
	}

	/**
	 * @param values the values to set
	 */
	public ClaimTO setValues(String[] values) {
		this.values = values;
		return this;
	}

	/**
	 * @return the claims
	 */
	
}
