/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * Claim user interface descriptor transfer object. Has meta information for building user friendly claim editor.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class ClaimUiDescriptorTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 *Might contain input mask for formating claim value on client side.
	 */
	private String inputMask;

	/**
	 * Should contain possible optional values If type equal 4 (TYPE_COMBOBOX ).
	 */
	private String[] optionalValues = null;

	/**
	 *Might contain regular express for validating user input on client side.
	 */
	private String pattern;

	/**
	 * Defines claim editor type. The following types/values were defined:
	 * <ul>
	 * <li>TextField GUI component type TYPE_TEXTFILED = 0;</li>
	 * <li>TextArea GUI component type TYPE_TEXTAREA = 1;</li>
	 * <li>FileChooser GUI component type TYPE_FILE = 2;</li>
	 * <li>CheckField GUI component type TYPE_CHECKBOX = 3;</li>
	 * <li>ComboBox GUI component type TYPE_COMBOBOX = 4;</li>
	 * <li>Date(time) GUI component type TYPE_DATETIME = 5.</li>
	 * </ul>
	 */
	private String type;

	/**
	 * @return the inputMask
	 */
	public String getInputMask() {
		return inputMask;
	}

	/**
	 * @return the optionalValues
	 */
	public String[] getOptionalValues() {
		return optionalValues;
	}

	/**
	 * @return the pattern
	 */
	public String getPattern() {
		return pattern;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param inputMask
	 *            the inputMask to set
	 */
	public void setInputMask(final String inputMask) {
		this.inputMask = inputMask;
	}

	/**
	 * @param optionalValues
	 *            the optionalValues to set
	 */
	public void setOptionalValues(final String[] optionalValues) {
		this.optionalValues = optionalValues;
	}

	/**
	 * @param pattern
	 *            the pattern to set
	 */
	public void setPattern(final String pattern) {
		this.pattern = pattern;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(final String type) {
		this.type = type;
	}

}
