/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * Represents command executed status TO.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class CmdExecStatusTO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Represents command id, @see {@link CommandTO#id}
	 * 
	 */
	private String id;

	/**
	 * Represent status code of executed command on server. It may be '0' or error code.
	 * 
	 */
	private String statusCode;

	/**
	 * Represent status message of executed command on server. it may be used for returning error message.
	 */
	private String statusMessage;

	/**
	 * Represents added/updated resource.
	 */
	private BaseTO resource;

	/**
	 * @return the resource
	 */
	public BaseTO getResource() {
		return resource;
	}

	/**
	 * @param resource
	 *            the resource to set
	 */
	public CmdExecStatusTO setResource(BaseTO resource) {
		this.resource = resource;
		return this;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return the statusCode
	 */
	public String getStatusCode() {
		return statusCode;
	}

	/**
	 * @return the statusMessage
	 */
	public String getStatusMessage() {
		return statusMessage;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public CmdExecStatusTO setId(String commandId) {
		this.id = commandId;
		return this;
	}

	/**
	 * @param statusCode
	 *            the statusCode to set
	 */
	public CmdExecStatusTO setStatusCode(String statusCode) {
		this.statusCode = statusCode;
		return this;
	}

	/**
	 * @param statusMessage
	 *            the statusMessage to set
	 */
	public CmdExecStatusTO setStatusMessage(String statusMessage) {
		this.statusMessage = statusMessage;
		return this;
	}

}
