/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * Command transfer object. Encapsulate commands in transfer objects . Please, see "Command" design pattern.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class CommandTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents command id, Client should use it it for processing command executed status @see CmdExecStatusTO.
	 * 
	 */
	private String id;

	/**
	 * Represents operation/command name. It must be one "Persist" or "Delete".
	 */
	private String name;

	/**
	 * Represents resource type. It might be "PCard","MCard","CardHistory","UserProfile" etc.
	 */
	private String resourceType;

	/**
	 * Represents server resource identifier.
	 * 
	 * @see BaseTO#getId()
	 */
	private String resourceId;

	/**
	 * Represents resource.
	 */
	private BaseTO resource;

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the resource
	 */
	public BaseTO getResource() {
		return resource;
	}

	/**
	 * @return the resourceId
	 */
	public String getResourceId() {
		return resourceId;
	}

	/**
	 * @return the resourceType
	 */
	public String getResourceType() {
		return resourceType;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public CommandTO setId(String id) {
		this.id = id;
		return this;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public CommandTO setName(String name) {
		this.name = name;
		return this;
	}

	/**
	 * @param resource
	 *            the resource to set
	 */
	public CommandTO setResource(BaseTO resource) {
		this.resource = resource;
		return this;
	}

	/**
	 * @param resourceId
	 *            the resourceId to set
	 */
	public CommandTO setResourceId(String resourceId) {
		this.resourceId = resourceId;
		return this;
	}

	/**
	 * @param resourceType
	 *            the resourceType to set
	 */
	public CommandTO setResourceType(String resourceType) {
		this.resourceType = resourceType;
		return this;
	}

}
