/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Crds File transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class CrdsFileTO extends FileTO {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents password phrase.
	 */
	private String passwordPhrase;

	/**
	 * @return the passwordPhrase
	 */
	public String getPasswordPhrase() {
		return passwordPhrase;
	}

	/**
	 * @param passwordPhrase
	 *            the passwordPhrase to set
	 */
	public CrdsFileTO setPasswordPhrase(String passwordPhrase) {
		this.passwordPhrase = passwordPhrase;
		return this;
	}

}
