/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * Token service credential descriptor transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class CredentialDescriptorTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represent credential type. it might be :
	 * <ul>
	 * <li>SelfIssuedCredential;</li>
	 * <li>X509V3Credential</li>
	 * <li>KerberosV5Credential</li>
	 * <li>UsernamePasswordCredential</li>
	 *</ul>
	 */
	private String type;

	/**
	 * Represent user friendly credential hint.
	 */
	private String displayCredentialHint;

	/**
	 * Represent xml element.
	 */
	private String credentialXmlElement;

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	public CredentialDescriptorTO setType(String type) {
		this.type = type;
		return this;
	}

	/**
	 * @return the displayCredentialHint
	 */
	public String getDisplayCredentialHint() {
		return displayCredentialHint;
	}

	/**
	 * @param displayCredentialHint the displayCredentialHint to set
	 */
	public CredentialDescriptorTO setDisplayCredentialHint(String displayCredentialHint) {
		this.displayCredentialHint = displayCredentialHint;
		return this;
	}

	/**
	 * @return the credentialXmlElement
	 */
	public String getCredentialXmlElement() {
		return credentialXmlElement;
	}

	/**
	 * @param credentialXmlElement the credentialXmlElement to set
	 */
	public CredentialDescriptorTO setCredentialXmlElement(String credentialXmlElement) {
		this.credentialXmlElement = credentialXmlElement;
		return this;
	}


}
