/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;
import java.net.URI;

import javax.xml.bind.annotation.XmlType;

/**
 *Token service Endpoint reference transfer object.
 * 
 * @see org.eclipse.higgins.icard.IEndpointReference.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class EndpointReferenceTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents address.
	 */
	private URI address;

	/**
	 * Represents Metadata Address URI if Metadata contains it.
	 */
	private URI metadataAddress;

	/**
	 * Represents Metadata element of TokenService.
	 */
	private String metadataXml;

	/**
	 * Represents Identity element of TokenService.
	 */
	private String identityXml;

	/**
	 * @return the address
	 */
	public URI getAddress() {
		return address;
	}

	/**
	 * @param address
	 *            the address to set
	 */
	public EndpointReferenceTO setAddress(URI address) {
		this.address = address;
		return this;
	}

	/**
	 * @return the metadataAddress
	 */
	public URI getMetadataAddress() {
		return metadataAddress;
	}

	/**
	 * @param metadataAddress
	 *            the metadataAddress to set
	 */
	public EndpointReferenceTO setMetadataAddress(URI metadataAddress) {
		this.metadataAddress = metadataAddress;
		return this;
	}

	/**
	 * @return the metadataXml
	 */
	public String getMetadataXml() {
		return metadataXml;
	}

	/**
	 * @param metadataXml
	 *            the metadataXml to set
	 */
	public EndpointReferenceTO setMetadataXml(String metadataXml) {
		this.metadataXml = metadataXml;
		return this;
	}

	/**
	 * @return the identityXml
	 */
	public String getIdentityXml() {
		return identityXml;
	}

	/**
	 * @param identityXml
	 *            the identityXml to set
	 */
	public EndpointReferenceTO setIdentityXml(String identityXml) {
		this.identityXml = identityXml;
		return this;
	}

	// /**
	// * Represents X509Certificate if Identity contains it.
	// */
	// private byte[] x509Certificate;

}
