/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Base binary file transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace="http://www.eclipse.org/higgins/cardsync/2009/")
public class FileTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represent binary file content.
	 * 
	 */
	private byte[] fileData;

	/**
	 * @return the fileData
	 */
	public byte[] getFileData() {
		return fileData;
	}

	/**
	 * @param fileData
	 *            the fileData to set
	 */
	public FileTO setFileData(byte[] fileData) {
		this.fileData = fileData;
		return this;
	}

}
