/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Managed card transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace="http://www.eclipse.org/higgins/cardsync/2009/")
public class MCardTO extends CardTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents array of security token services.
	 */
	private TokenServiceTO[] tokenServices;

	/**
	 * Represents requireAppliesTo card element.
	 */
	private Boolean requireAppliesTo;

	/**
	 * STS/IdP privacy policy
	 */
	private StsPrivacyPolicyTO stsPrivacyPolicyTO;

//	/**
//	 * Represents /ic07:RequireStrongRecipientIdentity extension element If <code>true</code> than Selector MUST only
//	 * allow the card to be used at a Relying Party that presents a cryptographically protected identity X.509v3
//	 * certificate.
//	 */
//	private Boolean strongRecipientIdentityRequired;

//	/**
//	 * Represents /ic07:IssuerInformation extension element
//	 */
//	private String ic07IssuerInformation;

//	/**
//	 * @return the ic07IssuerInformation
//	 */
//	public String getIc07IssuerInformation() {
//		return ic07IssuerInformation;
//	}

	/**
	 * @return the requireAppliesTo
	 */
	public Boolean getRequireAppliesTo() {
		return requireAppliesTo;
	}

//	/**
//	 * @return the strongRecipientIdentityRequired
//	 */
//	public Boolean getStrongRecipientIdentityRequired() {
//		return strongRecipientIdentityRequired;
//	}

	/**
	 * @return the stsPrivacyPolicyTO
	 */
	public StsPrivacyPolicyTO getStsPrivacyPolicyTO() {
		return stsPrivacyPolicyTO;
	}

	/**
	 * @return the tokenServices
	 */
	public TokenServiceTO[] getTokenServices() {
		return tokenServices;
	}

//	/**
//	 * @param ic07IssuerInformation
//	 *            the ic07IssuerInformation to set
//	 */
//	public void setIc07IssuerInformation(final String ic07IssuerInformation) {
//		this.ic07IssuerInformation = ic07IssuerInformation;
//	}

	/**
	 * @param requireAppliesTo
	 *            the requireAppliesTo to set
	 */
	public void setRequireAppliesTo(final Boolean requireAppliesTo) {
		this.requireAppliesTo = requireAppliesTo;
	}

//	/**
//	 * @param strongRecipientIdentityRequired
//	 *            the strongRecipientIdentityRequired to set
//	 */
//	public void setStrongRecipientIdentityRequired(final Boolean strongRecipientIdentityRequired) {
//		this.strongRecipientIdentityRequired = strongRecipientIdentityRequired;
//	}

	/**
	 * @param stsPrivacyPolicyTO
	 *            the stsPrivacyPolicyTO to set
	 */
	public void setStsPrivacyPolicyTO(final StsPrivacyPolicyTO stsPrivacyPolicyTO) {
		this.stsPrivacyPolicyTO = stsPrivacyPolicyTO;
	}

	/**
	 * @param tokenServices
	 *            the tokenServices to set
	 */
	public void setTokenServices(final TokenServiceTO[] tokenServices) {
		this.tokenServices = tokenServices;
	}

}
