/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.sync.to;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Base TO resource wrapper.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class ResourceTO {

	/**
	 * Represents resource.
	 */
	private BaseTO resource;

	/**
	 * @return the resource
	 */
	public BaseTO getResource() {
		return resource;
	}

	/**
	 * @param resource
	 *            the resource to set
	 */
	public ResourceTO setResource(BaseTO resource) {
		this.resource = resource;
		return this;
	}

}
