/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlType;

/**
 * Resource revision transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class RevisionTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents revision number.
	 */
	private Long number;

	/**
	 *Represents last modified date.
	 */
	private Date modifiedTime;

	/**
	 * @return the modifiedTime
	 */
	public Date getModifiedTime() {
		return modifiedTime;
	}

	/**
	 * @return the number
	 */
	public Long getNumber() {
		return number;
	}

	/**
	 * @param modifiedTime the modifiedTime to set
	 */
	public RevisionTO setModifiedTime(Date modifiedTime) {
		this.modifiedTime = modifiedTime;
		return this;
	}

	/**
	 * @param number the number to set
	 */
	public RevisionTO setNumber(Long number) {
		this.number = number;
		return this;
	}

	
}
