/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * STS/IdP privacy policy transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class StsPrivacyPolicyTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * STS/IdP privacy policy version.
	 */
	private String version;

	/**
	 * STS/IdP privacy policy url.
	 */
	private String url;

	/**
	 * @return the url
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * @return the version
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * @param version
	 *            the version to set
	 */
	public StsPrivacyPolicyTO setVersion(String version) {
		this.version = version;
		return this;
	}

	/**
	 * @param url
	 *            the url to set
	 */
	public StsPrivacyPolicyTO setUrl(String url) {
		this.url = url;
		return this;
	}

}
