/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * Token service transfer object.
 * 
 * @see org.eclipse.higgins.icard.ITokenService
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class TokenServiceTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents Token Service endpoint.
	 */
	private EndpointReferenceTO endpointReference;

	/**
	 * Represents Token Service credential.
	 */
	private CredentialDescriptorTO userCredential;

	/**
	 * @return the endpointReference
	 */
	public EndpointReferenceTO getEndpointReference() {
		return endpointReference;
	}

	/**
	 * @return the userCredential
	 */
	public CredentialDescriptorTO getUserCredential() {
		return userCredential;
	}

	/**
	 * @param endpointReference
	 *            the endpointReference to set
	 */
	public void setEndpointReference(final EndpointReferenceTO endpointReference) {
		this.endpointReference = endpointReference;
	}

	/**
	 * @param userCredential
	 *            the userCredential to set
	 */
	public void setUserCredential(final CredentialDescriptorTO userCredential) {
		this.userCredential = userCredential;
	}

}
