/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * User profile transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace="http://www.eclipse.org/higgins/cardsync/2009/")
public class UserProfileTO extends BaseTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents user login name.
	 */
	private String loginName;

	/**
	 * Represents user first name.
	 */
	private String firstName;

	/**
	 * Represents user last name.
	 */
	private String lastName;

	/**
	 * Represents user email address.
	 */
	private String email;

	/**
	 * Represents user mobile tel. It needs for sending sms password reset code.
	 */
	private String mobile;

	/**
	 * Represents user account created date.
	 */
	private Date createdTime;

	/**
	 * Represents referral tracking.
	 * 
	 * @see http://graceland.parityinc.net:8090/browse/WWM-1651
	 */
	private String referralTracking;

	/**
	 * Represents SendMeNews flag.
	 */
	private Boolean sendMeNews;

	/**
	 * Represents user authentication credential. it needs just for creating new UserProfile.
	 */
	private AuthCredentialTO authCredentialTO;

	/**
	 * @return the authCredentialTO
	 */
	public AuthCredentialTO getAuthCredentialTO() {
		return authCredentialTO;
	}

	/**
	 * @return the createdTime
	 */
	public Date getCreatedTime() {
		return createdTime;
	}

	/**
	 * @return the email
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * @return the lastName
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * @return the loginName
	 */
	public String getLoginName() {
		return loginName;
	}

	/**
	 * @return the mobile
	 */
	public String getMobile() {
		return mobile;
	}

	/**
	 * @return the referralTracking
	 */
	public String getReferralTracking() {
		return referralTracking;
	}

	/**
	 * @return the sendMeNews
	 */
	public Boolean getSendMeNews() {
		return sendMeNews;
	}

	/**
	 * @param authCredentialTO the authCredentialTO to set
	 */
	public UserProfileTO setAuthCredentialTO(AuthCredentialTO authCredentialTO) {
		this.authCredentialTO = authCredentialTO;
		return this;
	}

	/**
	 * @param createdTime the createdTime to set
	 */
	public UserProfileTO setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
		return this;
	}

	/**
	 * @param email the email to set
	 */
	public UserProfileTO setEmail(String email) {
		this.email = email;
		return this;
	}

	/**
	 * @param firstName the firstName to set
	 */
	public UserProfileTO setFirstName(String firstName) {
		this.firstName = firstName;
		return this;
	}

	/**
	 * @param lastName the lastName to set
	 */
	public UserProfileTO setLastName(String lastName) {
		this.lastName = lastName;
		return this;
	}

	/**
	 * @param loginName the loginName to set
	 */
	public UserProfileTO setLoginName(String loginName) {
		this.loginName = loginName;
		return this;
	}

	/**
	 * @param mobile the mobile to set
	 */
	public UserProfileTO setMobile(String mobile) {
		this.mobile = mobile;
		return this;
	}

	/**
	 * @param referralTracking the referralTracking to set
	 */
	public UserProfileTO setReferralTracking(String referralTracking) {
		this.referralTracking = referralTracking;
		return this;
	}

	/**
	 * @param sendMeNews
	 *            the sendMeNews to set
	 */
	public UserProfileTO setSendMeNews(Boolean sendMeNews) {
		this.sendMeNews = sendMeNews;
		return this;
	}

}
