/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * UsernamePasswordAuthCredential transfer object. it may be used for authentication with CardSync server.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace="http://www.eclipse.org/higgins/cardsync/2009/")
// @XmlAccessorType(XmlAccessType.FIELD)
// @XmlAccessorOrder(XmlAccessOrder.ALPHABETICAL)
// @XmlType(propOrder = { "username", "password" })
public class UsernamePasswordAuthCredentialTO extends AuthCredentialTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents username.
	 */
	// @XmlElement(name="username")
	private String username;

	/**
	 * Represents password.
	 */
	// @XmlElement(name="password")
	private String password;

	/**
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param password
	 *            the password to set
	 */
	public UsernamePasswordAuthCredentialTO setPassword(String password) {
		this.password = password;
		return this;
	}

	/**
	 * @param username
	 *            the username to set
	 */
	public UsernamePasswordAuthCredentialTO setUsername(String username) {
		this.username = username;
		return this;
	}

}