/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;
import java.net.URI;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * UsernamePasswordCredential credential transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlRootElement(namespace="http://www.eclipse.org/higgins/cardsync/2009/")
public class UsernamePasswordCredentialTO extends CardCredentialTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represents STS/IdP address.
	 */
	private URI tsAddress;

	/**
	 * Represents STS/IdP meta address
	 */
	private URI tsMetadataAddress;

	/**
	 * Represents username. It needs for supporting UsernamePasswordCredential.
	 */
	private String username;

	/**
	 * Represents password. It needs for supporting UsernamePasswordCredential.
	 */
	private String password;

	/**
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @return the tsAddress
	 */
	public URI getTsAddress() {
		return tsAddress;
	}

	/**
	 * @return the tsMetadataAddress
	 */
	public URI getTsMetadataAddress() {
		return tsMetadataAddress;
	}

	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param password
	 *            the password to set
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @param tsAddress
	 *            the tsAddress to set
	 */
	public void setTsAddress(URI tsAddress) {
		this.tsAddress = tsAddress;
	}

	/**
	 * @param tsMetadataAddress
	 *            the tsMetadataAddress to set
	 */
	public void setTsMetadataAddress(URI tsMetadataAddress) {
		this.tsMetadataAddress = tsMetadataAddress;
	}

	/**
	 * @param username
	 *            the username to set
	 */
	public void setUsername(String username) {
		this.username = username;
	}

}
