/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.to;

import java.io.Serializable;
import java.net.URI;

import javax.xml.bind.annotation.XmlType;

/**
 * Web form transfer object.
 * 
 * @author Alexander Yuhimenko
 * 
 */
@XmlType(namespace = "http://www.eclipse.org/higgins/cardsync/2009/")
public class WebFormTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 *Represents web page URL.
	 */
	private URI url;

	/**
	 *Represents html form name element.
	 */
	private String formName;

	/**
	 *Represents html form id element.
	 */
	private String formId;

	/**
	 *Represents html form action element.
	 */
	private String formAction;

	/**
	 * @return the formAction
	 */
	public String getFormAction() {
		return formAction;
	}

	/**
	 * @return the formId
	 */
	public String getFormId() {
		return formId;
	}

	/**
	 * @return the formName
	 */
	public String getFormName() {
		return formName;
	}

	/**
	 * @return the url
	 */
	public URI getUrl() {
		return url;
	}

	/**
	 * @param formAction
	 *            the formAction to set
	 */
	public void setFormAction(final String formAction) {
		this.formAction = formAction;
	}

	/**
	 * @param formId
	 *            the formId to set
	 */
	public void setFormId(final String formId) {
		this.formId = formId;
	}

	/**
	 * @param formName
	 *            the formName to set
	 */
	public void setFormName(final String formName) {
		this.formName = formName;
	}

	/**
	 * @param url
	 *            the url to set
	 */
	public void setUrl(final URI url) {
		this.url = url;
	}

}
