/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.utilities;

import java.io.IOException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.to.AuthCredentialTO;
import org.eclipse.higgins.sync.to.UsernamePasswordAuthCredentialTO;

/**
 * Few secure utility methods.
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class SecureUtil {

	
	/**
	 * Create CallbackHandler depends on AuthCredentialTO.
	 * 
	 * @param authCredentialTO
	 * @return CallbackHandler
	 */
	public static CallbackHandler getCallbackHandler(final AuthCredentialTO authCredentialTO) {
		return new CallbackHandler() {
			public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
				for (int i = 0; i < callbacks.length; i++) {
					if (callbacks[i] instanceof NameCallback) {
						((NameCallback) callbacks[i])
								.setName(authCredentialTO instanceof UsernamePasswordAuthCredentialTO ? ((UsernamePasswordAuthCredentialTO) authCredentialTO)
										.getUsername()
										: null);
					} else
						if (callbacks[i] instanceof PasswordCallback) {
							((PasswordCallback) callbacks[i])
									.setPassword(authCredentialTO instanceof UsernamePasswordAuthCredentialTO ? ((UsernamePasswordAuthCredentialTO) authCredentialTO)
											.getPassword().toCharArray()
											: null);
						}
				}
			}
		};
	}

	/**
	 * Create CallbackHandler with name password callbacks.
	 * 
	 * @param username
	 * @param password
	 * @return
	 */
	public static CallbackHandler getCallbackHandler(final String username, final String password) {
		return getCallbackHandler(new UsernamePasswordAuthCredentialTO().setPassword(password).setUsername(username));
	}

	
	/**
	 * Create CallbackHandler with name callback from user identifier.
	 * 
	 * @param username
	 * @param password
	 * @return
	 */
	public static CallbackHandler getCallbackHandler(final AccessTokenEntity accessTokenEntity) {
		return getCallbackHandler(new UsernamePasswordAuthCredentialTO().setUsername(accessTokenEntity.getUserIdentifier()));
	}
	
	/**
	 * Return JNDI environment.
	 * 
	 * @return
	 * @throws NamingException
	 */
	public static Context getContext() throws NamingException {
		Context initCtx = new InitialContext();
		return (Context) initCtx.lookup("java:comp/env");
	}

}
