/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.meta.hb;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.exceptions.ResourceMetaDataException;
import org.eclipse.higgins.sync.meta.hb.utilities.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class ResourceMetaDataService
implements IResourceMetaDataService {
    private static final String PERSIST_CMD_NAME = "Persist";
    private static Log LOG = LogFactory.getLog(ResourceMetaDataService.class);

    public void deleteResourceRevisionEntity(RevisionEntity revisionEntity) {
        try {
            RevisionEntity res = this.findResourceRevisionEntity(revisionEntity);
            if (null != res) {
                res.setCommandName("Delete");
                this.persistResourceRevisionEntity(res);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public RevisionEntity findResourceRevisionEntity(RevisionEntity revisionEntity) throws ResourceMetaDataException {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        try {
            RevisionEntity res;
            session.beginTransaction();
            Query query = null;
            query = "RootResource".equals(revisionEntity.getResourceType()) ? session.getNamedQuery("findRootRevisionEntityByResource") : session.getNamedQuery("findRevisionEntityByResource");
            query.setString("userId", revisionEntity.getUserId());
            query.setString("resourceType", revisionEntity.getResourceType());
            query.setString("resourceId", revisionEntity.getResourceId());
            RevisionEntity revisionEntity2 = res = (RevisionEntity)query.uniqueResult();
            return revisionEntity2;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new ResourceMetaDataException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
    }

    public RevisionEntity getResourceRevisionEntity(Long id) throws ResourceMetaDataException {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            RevisionEntity revisionEntity = (RevisionEntity)session.get(RevisionEntity.class, (Serializable)id);
            return revisionEntity;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new ResourceMetaDataException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
    }

    public void persistResourceRevisionEntity(RevisionEntity revisionEntity) throws ResourceMetaDataException {
        RevisionEntity entity = this.findResourceRevisionEntity(revisionEntity);
        if (null != revisionEntity && (null == revisionEntity.getCommandName() || "".equals(revisionEntity.getCommandName().trim()))) {
            revisionEntity.setCommandName(PERSIST_CMD_NAME);
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        try {
            session.beginTransaction();
            if (null != entity) {
                if (null != revisionEntity.getParentId() && !revisionEntity.getParentId().equals(entity.getParentId())) {
                    entity.setParentId(revisionEntity.getParentId());
                    session.update((Object)entity);
                }
                entity = this.updateRevisionTree(entity.getId());
                entity.setCommandName(revisionEntity.getCommandName());
                session.update((Object)entity);
                revisionEntity.setId(entity.getId());
                revisionEntity.setParentId(entity.getParentId());
                revisionEntity.setNumber(entity.getNumber());
                revisionEntity.setModifiedTime(entity.getModifiedTime());
                revisionEntity.setCommandName(entity.getCommandName());
            } else if ("RootResource".equals(revisionEntity.getResourceType())) {
                revisionEntity.setNumber(new Long(1L));
                revisionEntity.setModifiedTime(new Date());
                session.persist((Object)revisionEntity);
            } else if (null != revisionEntity.getParentId()) {
                RevisionEntity parentEntity = this.updateRevisionTree(revisionEntity.getParentId());
                revisionEntity.setModifiedTime(parentEntity.getModifiedTime());
                revisionEntity.setNumber(parentEntity.getNumber());
                session.saveOrUpdate((Object)revisionEntity);
            } else {
                throw new ResourceMetaDataException("Couldn't add ResourceRevisionEntity (not RootRevisionEntity ) with empty parentId.");
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            session.getTransaction().rollback();
            throw new ResourceMetaDataException(e.getMessage(), (Throwable)e);
        }
    }

    private RevisionEntity updateRevisionTree(Long id) throws ResourceMetaDataException {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        RevisionEntity entity = (RevisionEntity)session.get(RevisionEntity.class, (Serializable)id);
        if (null != entity.getParentId() && entity.getParentId() > 0L) {
            RevisionEntity parentEntity = this.updateRevisionTree(entity.getParentId());
            entity.setNumber(parentEntity.getNumber());
            entity.setModifiedTime(parentEntity.getModifiedTime());
        } else {
            entity.setNumber(Long.valueOf(entity.getNumber() + 1L));
            entity.setModifiedTime(new Date());
        }
        session.update((Object)entity);
        return entity;
    }

    public List getResourceRevisionEntityList(RevisionEntity clientRootRevision, String resourceType) throws ResourceMetaDataException {
        Session session = HibernateUtil.getSessionFactory().openSession();
        try {
            if (null == resourceType) {
                resourceType = "%";
            }
            session.beginTransaction();
            Query query = null;
            query = session.getNamedQuery("getResourceRevisionMoreThan");
            query.setString("userId", clientRootRevision.getUserId());
            query.setLong("number", clientRootRevision.getNumber().longValue());
            query.setString("resourceType", resourceType);
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            session.getTransaction().rollback();
            throw new ResourceMetaDataException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
    }

    public RevisionEntity findMaxRevisionEntity(RevisionEntity revisionEntity) throws ResourceMetaDataException {
        if (null != revisionEntity && "RootResource".equals(revisionEntity.getResourceType())) {
            return this.findResourceRevisionEntity(revisionEntity.setResourceId(revisionEntity.getUserId()));
        }
        Session session = HibernateUtil.getSessionFactory().openSession();
        try {
            session.beginTransaction();
            Query query = session.getNamedQuery("findMaxRevisionEntity");
            query.setString("userId", revisionEntity.getUserId());
            query.setString("resourceType", revisionEntity.getResourceType());
            RevisionEntity revisionEntity2 = (RevisionEntity)query.uniqueResult();
            return revisionEntity2;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            session.getTransaction().rollback();
            throw new ResourceMetaDataException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
    }
}

