/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.meta.hb;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import java.util.Properties;
import java.util.UUID;
import javax.naming.InitialContext;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RootRevisionEntity;
import org.eclipse.higgins.sync.meta.exceptions.ResourceMetaDataException;
import org.eclipse.higgins.sync.meta.hb.ResourceMetaDataService;
import org.gjt.mm.mysql.Driver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResourceMetaDataServiceTest {
    private ResourceMetaDataService dataService = new ResourceMetaDataService();
    private static String rootResourceId = "urn:testUserProfile";
    private String userId = "testUserProfile";
    private RootRevisionEntity rootRevisionEntity;
    private RevisionEntity resourceRevisioEntity;
    private static Long RootRevisionNumber = 0L;

    @BeforeClass
    public static void initDS() {
        try {
            rootResourceId = UUID.randomUUID().toString();
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
            InitialContext ic = new InitialContext();
            ic.createSubcontext("java:");
            ic.createSubcontext("java:comp");
            ic.createSubcontext("java:comp/env");
            ic.createSubcontext("java:comp/env/cardsync");
            Properties properties = new Properties();
            properties.put("url", "jdbc:mysql://rh152.sohosmart.net/hcs_meta?autoReconnect=true");
            properties.put("username", "higgins_cardsync");
            properties.put("password", "password");
            properties.put("driverClassName", "org.gjt.mm.mysql.Driver");
            Driver driver = new Driver();
            MysqlConnectionPoolDataSource dataSource = new MysqlConnectionPoolDataSource();
            dataSource.setUrl("jdbc:mysql://rh152.sohosmart.net/hcs_meta?autoReconnect=true");
            dataSource.setUser("higgins_cardsync");
            dataSource.setPassword("password");
            ic.bind("java:comp/env/cardsync/meta_hb", (Object)dataSource);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.rootRevisionEntity = new RootRevisionEntity();
        this.resourceRevisioEntity = new ResourceRevisionEntity();
        this.rootRevisionEntity.setUserId(this.userId);
        this.rootRevisionEntity.setResourceId(rootResourceId);
        this.rootRevisionEntity.setResourceType("RootResource");
        this.resourceRevisioEntity.setUserId(this.userId);
        this.resourceRevisioEntity.setResourceId("http://test.resource.id/");
        this.resourceRevisioEntity.setResourceType(this.resourceRevisioEntity.getClass().getCanonicalName());
    }

    @Test
    public void testPersistRootRevisionEntity() throws NullPointerException, ResourceMetaDataException {
        this.dataService.persistResourceRevisionEntity((RevisionEntity)this.rootRevisionEntity);
        Assert.assertNotNull((Object)this.rootRevisionEntity);
        RootRevisionNumber = RootRevisionNumber + 1L;
        Assert.assertNotNull((Object)this.rootRevisionEntity.getNumber());
        Assert.assertTrue((boolean)RootRevisionNumber.equals(this.rootRevisionEntity.getNumber()));
    }

    @Test
    public void testFindResourceRevisionEntity() throws NullPointerException, ResourceMetaDataException {
        RevisionEntity entity = this.dataService.findResourceRevisionEntity((RevisionEntity)this.rootRevisionEntity);
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)entity.getNumber().equals(RootRevisionNumber));
        Assert.assertTrue((boolean)(entity instanceof RootRevisionEntity));
    }

    @Test
    public void testGetResourceRevisionEntity() throws NullPointerException, ResourceMetaDataException {
        RevisionEntity entity = this.dataService.getResourceRevisionEntity(this.dataService.findResourceRevisionEntity((RevisionEntity)this.rootRevisionEntity).getId());
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)entity.getNumber().equals(RootRevisionNumber));
        Assert.assertTrue((boolean)(entity instanceof RootRevisionEntity));
    }

    @Test
    public void testUpdateRootRevisionEntity() throws NullPointerException, ResourceMetaDataException {
        this.dataService.persistResourceRevisionEntity((RevisionEntity)this.rootRevisionEntity);
        RootRevisionNumber = RootRevisionNumber + 1L;
        Assert.assertNotNull((Object)this.rootRevisionEntity);
        Assert.assertTrue((boolean)RootRevisionNumber.equals(this.rootRevisionEntity.getNumber()));
    }

    @Test
    public void testPersistResourceRevisionEntity() throws NullPointerException, ResourceMetaDataException {
        RevisionEntity parentEntity = this.dataService.findResourceRevisionEntity((RevisionEntity)this.rootRevisionEntity);
        this.resourceRevisioEntity.setParentId(parentEntity.getId());
        this.dataService.persistResourceRevisionEntity(this.resourceRevisioEntity);
        RootRevisionNumber = RootRevisionNumber + 1L;
        Assert.assertNotNull((Object)this.resourceRevisioEntity);
        Assert.assertTrue((this.resourceRevisioEntity.getNumber() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)RootRevisionNumber.equals(this.dataService.findResourceRevisionEntity((RevisionEntity)this.rootRevisionEntity).getNumber()));
    }

    @Test
    public void testDeleteResourceRevisionEntity() throws NullPointerException, ResourceMetaDataException {
        this.dataService.deleteResourceRevisionEntity(this.resourceRevisioEntity);
        RootRevisionNumber = RootRevisionNumber + 1L;
        RevisionEntity revisionEntity = this.dataService.findResourceRevisionEntity((RevisionEntity)this.rootRevisionEntity);
        Assert.assertTrue((boolean)RootRevisionNumber.equals(revisionEntity.getNumber()));
    }

    @Test
    public void testDeleteRootRevisionEntity() throws NullPointerException, ResourceMetaDataException {
        this.dataService.deleteResourceRevisionEntity((RevisionEntity)this.rootRevisionEntity);
    }
}

