/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.meta.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * Base resource revision entity.
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class RevisionEntity implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Represent entity Id.
	 */
	private Long id;

	/**
	 * Represent user identifier.
	 */
	private String userId;

	/**
	 * Represent parent entity Id.
	 */
	private Long parentId;

	/**
	 * Represents revision number.
	 */
	private Long number;

	/**
	 *Represents last modified date.
	 */
	private Date modifiedTime;

	/**
	 * Represents resource identifier.
	 */
	private String resourceId;

	/**
	 * Represents resource type.
	 */
	private String resourceType;

	/**
	 * Represents last command name.
	 */
	private String commandName;

	/**
	 * @return the commandName
	 */
	public String getCommandName() {
		return commandName;
	}

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @return the modifiedTime
	 */
	public Date getModifiedTime() {
		return modifiedTime;
	}

	/**
	 * @return the number
	 */
	public Long getNumber() {
		return number;
	}

	/**
	 * @return the parentId
	 */
	public Long getParentId() {
		return parentId;
	}

	/**
	 * @return the resourceId
	 */
	public String getResourceId() {
		return resourceId;
	}

	/**
	 * @return the resourceType
	 */
	public String getResourceType() {
		return resourceType;
	}

	/**
	 * @return the userId
	 */
	public String getUserId() {
		return userId;
	}

	/**
	 * @param commandName
	 *            the commandName to set
	 */
	public RevisionEntity setCommandName(String commandName) {
		this.commandName = commandName;
		return this;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public RevisionEntity setId(Long id) {
		this.id = id;
		return this;
	}

	/**
	 * @param modifiedTime
	 *            the modifiedTime to set
	 */
	public RevisionEntity setModifiedTime(Date modifiedTime) {
		this.modifiedTime = modifiedTime;
		return this;
	}

	/**
	 * @param number
	 *            the number to set
	 */
	public RevisionEntity setNumber(Long number) {
		this.number = number;
		return this;
	}

	/**
	 * @param parentId
	 *            the parentId to set
	 */
	public RevisionEntity setParentId(Long parentId) {
		this.parentId = parentId;
		return this;
	}

	/**
	 * @param resourceId
	 *            the resourceId to set
	 */
	public RevisionEntity setResourceId(String resourceId) {
		this.resourceId = resourceId;
		return this;
	}

	/**
	 * @param resourceType
	 *            the resourceType to set
	 */
	public RevisionEntity setResourceType(String resourceType) {
		this.resourceType = resourceType;
		return this;
	}

	/**
	 * @param userId
	 *            the userId to set
	 */
	public RevisionEntity setUserId(String userId) {
		this.userId = userId;
		return this;
	}

}
