/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.sync.meta.utilities;

import java.io.Serializable;

import org.eclipse.higgins.sync.meta.IResourceMetaDataService;
import org.eclipse.higgins.sync.meta.entity.ResourceRevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RevisionEntity;
import org.eclipse.higgins.sync.meta.entity.RootRevisionEntity;
import org.eclipse.higgins.sync.meta.exceptions.ResourceMetaDataException;

/**
 * Resource MetaData utilities.
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class ResourceUtil {

	/**
	 * Persist RootRevisionEntity.
	 * 
	 * @param service
	 * @param userIdentifier
	 * @return
	 * @throws ResourceMetaDataException
	 */
	public RootRevisionEntity persistRoorRevision(IResourceMetaDataService service, Serializable userIdentifier)
			throws ResourceMetaDataException {
		RootRevisionEntity rootRevisionEntity = new RootRevisionEntity();
		rootRevisionEntity.setResourceType(IResourceMetaDataService.ROOT_RESOURCE_TYPE).setResourceId(
				(String) userIdentifier).setUserId((String) userIdentifier);
		service.persistResourceRevisionEntity(rootRevisionEntity);
		return rootRevisionEntity;
	}

	/**
	 * Persist ResourceRevisionEntity.
	 * 
	 * @param service
	 * @param userId
	 * @param resourceId
	 * @param parentResourceId
	 * @return
	 * @throws ResourceMetaDataException
	 */
	public ResourceRevisionEntity persistResourceRevision(IResourceMetaDataService service, Serializable userId,
			String resourceType, String resourceId, Long parentResourceId) throws ResourceMetaDataException {
		ResourceRevisionEntity revisionEntity = new ResourceRevisionEntity();
		revisionEntity.setResourceType(IResourceMetaDataService.USER_PROFILE_RESOURCE_TYPE).setResourceId(resourceId)
				.setUserId((String) userId).setParentId(parentResourceId);
		service.persistResourceRevisionEntity(revisionEntity);
		return revisionEntity;
	}

	/**
	 * Find Root revision entity.
	 * 
	 * @param service
	 * @param userId
	 * @return
	 * @throws ResourceMetaDataException
	 */
	public RevisionEntity findRootRevision(IResourceMetaDataService service, String userId)
			throws ResourceMetaDataException {
		// find root (parent) revision entity
		return service.findResourceRevisionEntity(new RootRevisionEntity().setUserId(userId).setResourceId(userId)
				.setResourceType(IResourceMetaDataService.ROOT_RESOURCE_TYPE));
	}

}
